% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{calibrate}
\alias{calibrate}
\title{calibrate()}
\usage{
calibrate(
  oob,
  alpha = 0.1,
  response_data,
  tolerance = 0.025,
  step_percent = 0.618,
  undercoverage = FALSE,
  method = "quantile",
  max_iter = 10
)
}
\arguments{
\item{oob}{collection of oob predictions for training data (in list form).}

\item{alpha}{nominal significance level. Defaults to 0.01.}

\item{response_data}{response data of class data.frame. Must have names() attribute.}

\item{tolerance}{tolerance allowed around nominal alpha. Default is 0.25.}

\item{step_percent}{ratio absolute difference between empirical oob coverage and nominal coverage to adjust when calibrating. Defaults to 0.618.}

\item{undercoverage}{Allow undercoverage. Defaults to TRUE. Not currently implemented.}

\item{method}{Method to calibrate prediction intervals with. Defaults to "quantile"). Current only "quantile" implemented.}

\item{max_iter}{Maximum number of iterations. Defaults to 10.}
}
\description{
This function outputs a calibrated significance level based on coverage of prediction intervals generated using oob collections. Primarily for use in RoyRF().
}
\keyword{internal}
