% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.piar_index.R
\name{stack.piar_index}
\alias{stack.piar_index}
\alias{unstack.piar_index}
\title{Stack price indexes}
\usage{
\method{stack}{piar_index}(x, y, ...)

\method{unstack}{piar_index}(x, ...)
}
\arguments{
\item{x}{A price index, as made by, e.g., \code{\link[=elemental_index]{elemental_index()}}.}

\item{y}{A price index, or something that can coerced into one. If \code{x}
is a period-over-period index then \code{y} is coerce into a chainable
index; otherwise, \code{y} is coerced into a direct index.}

\item{...}{Further arguments passed to or used by methods.}
}
\value{
A price index that inherits from \code{\link{chainable_piar_index}} if \code{x} is a
period-over-period index, or \code{\link{direct_piar_index}} if \code{x} is a fixed-base
index. If both \code{x} and \code{y} are aggregate indexes then the result will also
inherit from \code{\link{aggregate_piar_index}}.

\code{unstack()} returns a list of price indexes with the same class as \code{x}.
}
\description{
\code{stack()} combines two price indexes with common levels, stacking index
values and percent-change contributions for one index after the other.

\code{unstack()} breaks up a price index into a list of indexes for each
time period.

These methods can be used in a map-reduce to make an index with multiple
aggregation structures (like a Paasche index).
}
\examples{
prices <- data.frame(
  rel = 1:8,
  period = rep(1:2, each = 4),
  ea = rep(letters[1:2], 4)
)

prices2 <- data.frame(
  rel = 1:8,
  period = rep(3:4, each = 4),
  ea = rep(letters[1:2], 4)
)

epr <- with(prices, elemental_index(rel, period, ea))

epr2 <- with(prices2, elemental_index(rel, period, ea))

stack(epr, epr2)

# Unstack does the reverse

all.equal(
  c(unstack(epr), unstack(epr2)),
  unstack(stack(epr, epr2))
)

}
\seealso{
Other index methods: 
\code{\link{[.piar_index}()},
\code{\link{aggregate.piar_index}()},
\code{\link{as.data.frame.piar_index}()},
\code{\link{chain}()},
\code{\link{contrib}()},
\code{\link{head.piar_index}()},
\code{\link{levels.piar_index}()},
\code{\link{mean.piar_index}()},
\code{\link{merge.piar_index}()},
\code{\link{time.piar_index}()},
\code{\link{vcov.aggregate_piar_index}()}
}
\concept{index methods}
