% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{remove_control_characters}
\alias{remove_control_characters}
\title{Remove Non-Character Characters}
\usage{
remove_control_characters(text)
}
\arguments{
\item{text}{A character vector to clean.}
}
\value{
The character vector without control characters.
}
\description{
Unicode includes several control codes, such as \code{U+0000} (NULL, used in
null-terminated strings) and \code{U+000D} (carriage return). This function
removes all such characters from text.
}
\details{
Note: We highly recommend that you first condense all space-like characters
(including new lines) before removing control codes. You can easily do so
with \code{\link[stringr]{str_squish}}. We also recommend validating text at
the start of any cleaning process using \code{\link{validate_utf8}}.
}
\examples{
remove_control_characters("Line 1\nLine2")
}
