% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pif_confidence_approximate_loglinear.R
\name{pif.confidence.approximate.loglinear}
\alias{pif.confidence.approximate.loglinear}
\title{Confidence Intervals for the Potential Impact Fraction when only mean
 and variance of exposure values is available using loglinear method}
\usage{
pif.confidence.approximate.loglinear(Xmean, Xvar, thetahat, thetavar, rr,
  cft = NA, deriv.method.args = list(), deriv.method = c("Richardson",
  "complex"), check_exposure = TRUE, check_rr = TRUE,
  check_integrals = TRUE, nsim = 1000, confidence = 95,
  check_thetas = TRUE, is_paf = FALSE)
}
\arguments{
\item{Xmean}{Mean value of exposure levels from a cross-sectional.}

\item{Xvar}{Variance of the exposure levels.}

\item{thetahat}{Estimator (vector or matrix) of \code{theta} for the Relative
Risk function \code{rr}}

\item{thetavar}{Estimator of variance of \code{thetahat}}

\item{rr}{Function for Relative Risk which uses parameter \code{theta}.
 The order of the parameters shound be \code{rr(X, theta)}.
 
 
\strong{**Optional**}}

\item{cft}{Differentiable function \code{cft(X)} for counterfactual.
Leave empty for the Population Attributable Fraction \code{\link{paf}} where
counterfactual is 0 exposure.}

\item{deriv.method.args}{\code{method.args} for 
\code{\link[numDeriv]{hessian}}.}

\item{deriv.method}{\code{method} for \code{\link[numDeriv]{hessian}}. 
Don't change this unless you know what you are doing.}

\item{check_exposure}{Check that exposure \code{X} is positive and numeric.}

\item{check_rr}{Check that Relative Risk function \code{rr} equals 
\code{1} when evaluated at \code{0}.}

\item{check_integrals}{Check that counterfactual and relative risk's expected 
values are well defined for this scenario.}

\item{nsim}{Number of simulations for estimation of variance}

\item{confidence}{Concidence level (0 to 100) default = \code{95} \%}

\item{check_thetas}{Checks that theta parameters are correctly inputed}

\item{is_paf}{Boolean forcing evaluation of \code{paf}}
}
\description{
Confidence intervals for the Population Attributable Fraction for
 the approximate method where only mean and variance from a previous study is
 available.For relative risk inyective functions, the pif is inyective, and
 intervals can be calculated for log(pif), and then transformed to pif CI.
}
\examples{

#Example 1: Exponential Relative Risk
#--------------------------------------------
set.seed(46987)
rr      <- function(X,theta){exp(X*theta)}
cft     <- function(X){0.4*X}
Xmean   <- data.frame(3)
Xvar    <- 1
theta   <- 0.4
thetavar <- 0.001
pif.confidence.approximate.loglinear(Xmean, Xvar, theta, thetavar, rr, cft,
nsim = 1000)

#Example 2: Multivariate Relative Risk
#--------------------------------------------
X1       <- rnorm(100,3,.5)
X2       <- rnorm(100,4,1)
X        <- data.frame(cbind(X1,X2))
Xmean    <- t(as.matrix(colMeans(X)))
Xvar     <- cov(X)
thetahat <- c(0.12, 0.17)
thetavar  <- matrix(c(0.001, 0.00001, 0.00001, 0.004), byrow = TRUE, nrow = 2)
rr       <- function(X, theta){exp(theta[1]*X[,1] + theta[2]*X[,2])}
pif.confidence.approximate.loglinear(Xmean, Xvar, thetahat, thetavar, 
rr, cft = function(X){0.8*X}, nsim = 100)

}
\author{
Rodrigo Zepeda-Tello \email{rzepeda17@gmail.com}

Dalia Camacho-García-Formentí \email{daliaf172@gmail.com}
}
\keyword{internal}
