% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pif_confidence_bootstrap.R
\name{pif.confidence.bootstrap}
\alias{pif.confidence.bootstrap}
\title{Pivotal Boostrap Confidence Intervals for Potential Impact Fraction}
\usage{
pif.confidence.bootstrap(X, thetahat, thetavar, rr, cft = NA,
  weights = rep(1/nrow(as.matrix(X)), nrow(as.matrix(X))),
  method = c("empirical", "kernel"), nboost = 10000, adjust = 1,
  n = 512, confidence = 95, ktype = c("gaussian", "epanechnikov",
  "rectangular", "triangular", "biweight", "cosine", "optcosine"),
  bw = c("SJ", "nrd0", "nrd", "ucv", "bcv"), check_exposure = TRUE,
  check_rr = TRUE, check_integrals = TRUE, check_thetas = TRUE,
  is_paf = FALSE)
}
\arguments{
\item{X}{Random sample (vector or matrix) which includes exposure and
covariates.}

\item{thetahat}{Maximum Likelihood estimator (vector or matrix) of
\code{theta} for the Relative Risk function.}

\item{thetavar}{Estimator of variance of \code{thetahat}}

\item{rr}{Function for Relative Risk which uses parameter 
\code{theta}. The order of the parameters shound be \code{rr(X, theta)}.


**Optional**}

\item{cft}{Function \code{cft(X)} for counterfactual. Leave empty for 
the Population Attributable Fraction \code{\link{paf}} where counterfactual
is 0 exposure.}

\item{weights}{Normalized survey \code{weights} for the sample \code{X}.}

\item{method}{Either \code{empirical} (default), or \code{kernel}}

\item{nboost}{Number of samples in Bootstrap}

\item{adjust}{Adjust bandwith parameter from density (for \code{kernel} 
method) from \code{\link[stats]{density}}.}

\item{n}{Number of equally spaced points at which the density (for 
\code{kernel} method) is to be estimated (see 
\code{\link[stats]{density}}).}

\item{confidence}{Concidence level (0 to 100) default = \code{95} \%}

\item{ktype}{\code{kernel} type:  \code{"gaussian"}, 
\code{"epanechnikov"}, \code{"rectangular"}, \code{"triangular"}, 
\code{"biweight"}, \code{"cosine"}, \code{"optcosine"} (for \code{kernel} 
method). Additional information on kernels in \code{\link[stats]{density}}}

\item{bw}{Smoothing bandwith parameter from density (for \code{kernel}
method) from \code{\link[stats]{density}}. Default \code{"SJ"}.}

\item{check_exposure}{Check that exposure \code{X} is positive and numeric}

\item{check_rr}{Check that Relative Risk function \code{rr} equals 
\code{1} when evaluated at \code{0}}

\item{check_integrals}{Check that counterfactual and relative risk's expected
values are well defined for this scenario}

\item{check_thetas}{Checks that theta parameters are correctly inputed}

\item{is_paf}{Boolean forcing evaluation of \code{paf}}
}
\value{
pif      Estimate of Potential Impact Fraction
}
\description{
Estimates a 1 - alpha pivotal confidence interval for the
  potential impact fraction \code{pif} using a boostrap approximation.
}
\examples{
#Example 1: Exponential Relative Risk
#----------------------------------------
set.seed(18427)
X        <- rnorm(100,5,1)
thetahat <- 0.4
thetavar <- 0.1
pif.confidence.bootstrap(X, thetahat, thetavar, function(X, theta){exp(theta*X)}, 
                         nboost = 100) #nboost small only for example purposes

#This also works with kernel method
pif.confidence.bootstrap(X, thetahat, thetavar, function(X, theta){exp(theta*X)}, 
                         nboost = 100, method = "kernel") 

#Example 2: Multivariate example
#----------------------------------------
\dontrun{
set.seed(18427)
X1 <- rnorm(100, 1, 0.05)
X2 <- rnorm(100, 1, 0.05)
X  <- as.matrix(cbind(X1,X2))
thetahat <- c(2, 0.03)
thetavar <- matrix(c(0.1, 0, 0, 0.05), byrow = TRUE, nrow = 2)
rr        <- function(X, theta){
  .X <- as.matrix(X, ncol = 2)
  exp(theta[1]*.X[,1] + theta[2]*.X[,2])
}
cft <- function(X){0.5*X}#' cft <- function(X){0.95*X}
pif.confidence.bootstrap(X, thetahat, thetavar, rr, cft) 
}
}
\author{
Rodrigo Zepeda-Tello \email{rzepeda17@gmail.com}

Dalia Camacho-García-Formentí \email{daliaf172@gmail.com}
}
\keyword{internal}
