% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_genotype.R
\name{germlineASC}
\alias{germlineASC}
\title{Converts IGHV germline set to ASC germline set.}
\usage{
germlineASC(allele_cluster_table, germline)
}
\arguments{
\item{allele_cluster_table}{The allele cluster table.}

\item{germline}{An IGHV germline set with matching names to the "imgt_allele" column in the allele_cluster_table.}
}
\value{
Returns the IGHV germline set with the ASC allele names.
}
\description{
Converts IGHV germline set to ASC germline set.
}
\examples{

# preferably obtain the latest ASC cluster table
# asc_archive <- recentAlleleClusters(doi="10.5281/zenodo.7429773", get_file = TRUE)

# allele_cluster_table <- extractASCTable(archive_file = asc_archive)

data(HVGERM)

# example allele similarity cluster table
data(allele_cluster_table)

asc_germline <- germlineASC(allele_cluster_table, germline = HVGERM)



}
