% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetSpecialLine.R
\name{GetSpecialLine}
\alias{GetSpecialLine}
\title{Get the Line for a Special Contestant}
\usage{
GetSpecialLine(specialId, contestantId, oddsFormat = "AMERICAN")
}
\arguments{
\item{specialId}{The ID of the special for the contestant.}

\item{contestantId}{The ID of the contestant.}

\item{oddsFormat}{Format for the returned odds. One of \code{"AMERICAN"},
\code{"DECIMAL"}, \code{"HONGKONG"}, \code{"INDONESIAN"}, or
\code{"MALAY"}.}
}
\value{
A data frame with the following columns:

\describe{
  \item{\code{status}}{When a line ID is retrieved this will contain the
    code \code{"SUCCESS"}. Otherwise it may contain \code{"NOT_EXISTS"} or
    \code{"OFFLINE"}.}
  \item{\code{specialId}}{The ID of the special.}
  \item{\code{contestantId}}{The ID of the contestant.}
  \item{\code{minRiskStake}}{Minimum bettable risk amount.}
  \item{\code{maxRiskStake}}{Maximum bettable risk amount.}
  \item{\code{minWinStake}}{Minimum bettable win amount.}
  \item{\code{maxWinStake}}{Maximum bettable win amount.}
  \item{\code{lineId}}{Line ID needed to place a bet.}
  \item{\code{price}}{Latest price.}
  \item{\code{handicap}}{Handicap value, if applicable.}
}
}
\description{
Queries the current line and odds for a given contestant in a special.
}
\details{
This function will raise an error if the API does not return HTTP status
\code{OK}. For information on the possible errors, see the API documentation
for \href{https://pinnacleapi.github.io/linesapi#operation/Line_Special_V1_Get}{Get Special Line}.
}
\examples{
\donttest{
SetCredentials("TESTAPI", "APITEST")
AcceptTermsAndConditions(accepted = TRUE)

# This contest is unlikely to exist, but serves as an example
# of the format.
GetSpecialLine(specialId = 101, contestantId = 102,
               oddsFormat = "AMERICAN")
}

}
\seealso{
See \code{\link{GetLine}} to retrieve non-special lines,
\code{\link{GetSpecialFixtures}} to query available special contestants, and
\code{\link{PlaceSpecialBet}} to actually wager on a contestant.
}
