% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_set_params_at_step}
\alias{pipe_set_params_at_step}
\title{Set parameters at step}
\usage{
pipe_set_params_at_step(pip, step, params)
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{step}{\code{string} the name of the step}

\item{params}{\code{list} of parameters to be set}
}
\value{
returns the \code{Pipeline} object invisibly
}
\description{
Set unbound function parameters defined at given pipeline
step where 'unbound' means parameters that are not linked to other
steps. If one or more parameters don't exist, an error is given.
}
\examples{
p <- pipe_new("pipe", data = 1)
pipe_add(p, "add1", \(x = ~data, y = 2, z = 3) x + y)
pipe_set_params_at_step(p, step = "add1", params = list(y = 5, z = 6))
pipe_get_params(p)

try(
  pipe_set_params_at_step(p, step = "add1", params = list(foo = 3))
)
}
