% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{predict.ml_pipeline}
\alias{predict.ml_pipeline}
\title{Predict method for ML pipelines}
\usage{
\method{predict}{ml_pipeline}(object, data, verbose = FALSE,
  pred_var = "pred_model", ...)
}
\arguments{
\item{object}{An estimated pipleine object of class \code{ml_pipeline}.}

\item{data}{A data.frame in which to look for input variables with which to predict.}

\item{verbose}{Boolean - whether or not to return data.frame with all input and interim
variables as well as predictions.}

\item{pred_var}{Name to assign to for column of predictions from the 'raw' (or inner) model in
the pipeline.}

\item{...}{Any additional arguements than need to be passed to the underlying model's predict
methods.}
}
\value{
A vector of model predictions or scores (default); or, a data.frame containing the
predicted values, input variables, as well as any interim tranformed variables.
}
\description{
Predict method for ML pipelines
}
\examples{
data <- faithful

lm_pipeline <-
  pipeline(
    data,
    estimate_model(function(df) {
      lm(eruptions ~ 1 + waiting, df)
    })
  )

in_sample_predictions <- predict(lm_pipeline, data)
head(in_sample_predictions)
# [1] 4.100592 2.209893 3.722452 2.814917 4.554360 2.285521
}

