% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{try_pipeline_func_call}
\alias{try_pipeline_func_call}
\title{Custom tryCatch configuration for pipeline segment segment functions}
\usage{
try_pipeline_func_call(.f, arg, func_name)
}
\arguments{
\item{.f}{Pipleine segment function}

\item{arg}{Arguement of \code{.f}}

\item{func_name}{(Character string).}
}
\value{
Returns the same object as .f does (a data.frame or model object), unless an error is
thrown.
}
\description{
Custom tryCatch configuration for pipeline segment segment functions
}
\examples{
\dontrun{
data <- data.frame(x = 1:3, y = 1:3 / 10)
f <- function(df) data.frame(p = df$x ^ 2, q = df$wrong)
try_pipeline_func_call(f, data, "f")
# Error in data.frame(p = df$x^2, q = df$wrong) :
#   arguments imply differing number of rows: 3, 0
# --> called from within function: f
}
}

