% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kgf_mpa.R
\name{kgf_mpa}
\alias{kgf_mpa}
\title{Megapascals to kilogram-force per square}
\usage{
kgf_mpa(x)
}
\arguments{
\item{x}{pressure (stress) measured in \emph{megapascals},
[\emph{MPa}]. Type: \code{\link{assert_double}}.}
}
\value{
pressure (stress) in
 \emph{kilogram-force per square cm}, [\emph{kgf/cm^2}].
 Type: \code{\link{assert_double}}.
}
\description{
Convert pressure (stress) measured in \href{https://en.wikipedia.org/wiki/Pascal_(unit)}{megapascals} (MPa)
 to \href{https://en.wikipedia.org/wiki/Kilogram-force_per_square_centimetre}{kilogram-force per square cm} (\eqn{kgf/cm^2}).
}
\examples{
 kgf_mpa(c(0.0980665, 1))
 # [1]  1.00000 10.19716


}
\seealso{
\code{\link{mpa_kgf}} for converting \emph{kilogram-force per square cm} to \emph{megapascals}

Other utils: 
\code{\link{inch_mm}()},
\code{\link{mm_inch}()},
\code{\link{mpa_kgf}()},
\code{\link{mpa_psi}()},
\code{\link{psi_mpa}()}
}
\concept{utils}
