% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m325nhldata.R
\docType{data}
\name{m325nhldata}
\alias{m325nhldata}
\title{Minenergo-325. Data for normative heat losses of pipe}
\format{
A data frame with 17328 rows and 8 variables:
\describe{
  \item{source}{Identifier of data source: identifiers suited with
    glob \emph{t?p?} mean appropriate \emph{table ?.?} in
    \href{http://docs.cntd.ru/document/902148459}{Minenergo Order 325};
    identifier \emph{sgc} means that values are additionally
    postulated (see \emph{Details}).
    Type: \code{\link{assert_character}}.
  }
  \item{epoch}{Year depicting the epoch when the pipe is put in operation after laying or total overhaul.
  Type: \code{\link{assert_integer}}.}
  \item{laying}{Type of pipe laying depicting the position of pipe in space. Only five types of
    pipe laying are considered:
    \itemize{
     \item \code{air},
     \item \code{channel},
     \item \code{room},
     \item \code{tunnel},
     \item \code{underground}.
    }
    Type: \code{\link{assert_character}}.
  }

  \item{exp5k}{
    Logical indicator for pipe regime: if \code{TRUE} pipe is
    operated more that \code{5000} hours per year.
    Type: \code{\link{assert_logical}}.
  }

  \item{insulation}{
    Identifier of insulation that covers the exterior of pipe:
    \describe{
      \item{\code{0}}{no insulation}
      \item{\code{1}}{foamed polyurethane or analogue}
      \item{\code{2}}{polymer concrete}
    }
   Type: \code{\link{assert_integerish}}.
  }

  \item{diameter}{Nominal internal diameter of pipe, [mm]. Type: \code{\link{assert_double}}.}

  \item{temperature}{Operational temperature of pipe, [°C]. Type: \code{\link{assert_double}}.}

  \item{flux}{
    Heat flux emitted by every meter of pipe during an hour, [kcal/m/hour].
    Type: \code{\link{assert_double}}.}
 }
}
\source{
\url{http://docs.cntd.ru/document/902148459}
}
\usage{
m325nhldata
}
\description{
Data represent values of heat losses officially accepted by
\href{http://docs.cntd.ru/document/902148459}{Minenergo Order 325} as
norms. Those values represent heat flux that is legally
affirmed to be emitted per meter during an hour by steel pipe of district
heating system with water as a heat carrier.
}
\details{
Data is organized as a full factorial design, whereas for some factorial
combinations \href{http://docs.cntd.ru/document/902148459}{Minenergo Order 325}
does not provide values. For that cases values are postulated by practical
reasons in Siberian cities and marked with source label \emph{sgc}.

Usually the data is not used directly. Instead use function \code{\link{m325nhl}}.
}
\seealso{
Other Minenergo: 
\code{\link{m278hlair}()},
\code{\link{m278hlcha}()},
\code{\link{m278hlund}()},
\code{\link{m278insdata}},
\code{\link{m278inshcm}()},
\code{\link{m278soildata}},
\code{\link{m325beta}()},
\code{\link{m325dropt}()},
\code{\link{m325nhl}()},
\code{\link{m325testbench}}
}
\concept{Minenergo}
\keyword{datasets}
