% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/check_experiments_candidates_have_same_beast2_files.R
\name{check_candidates_save_to_same_files}
\alias{check_candidates_save_to_same_files}
\title{Check if all experiments save to the same files}
\usage{
check_candidates_save_to_same_files(experiments)
}
\arguments{
\item{experiments}{a list of one or more \link{pirouette} experiments,
as can be created by \link{create_experiment}. If more than one experiment
is provided and a "generative" experiment is part of them, the "generative"
one has to be the first in the list. See also:
\itemize{
  \item Use \link{check_experiments} to check the list of
    experiments for validity
  \item Use \link{create_all_experiments} to create experiments with
    all combinations of tree model, clock model and tree priors
  \item Use \link{create_all_bd_experiments} to create experiments
    with all combinations of tree model, clock model and tree priors,
    except for only using birth-death tree priors
  \item Use \link{create_all_coal_experiments} to create all experiments
    with all combinations of tree model, clock model and tree priors,
    except for only coalescent tree priors
  \item Use \link{shorten_experiments} to shorten the run time
    of the list of experiments
}}
}
\value{
nothing
}
\description{
Will \link{stop} if two experiments save to a different input,
trace, state, screen or tree file.
}
\author{
Richèl J.C. Bilderbeek
}
