% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nltt_error_fun.R
\name{get_nltt_error_fun}
\alias{get_nltt_error_fun}
\title{Get an error function that uses the nLTT statistic}
\usage{
get_nltt_error_fun()
}
\value{
a numeric vector of errors
}
\description{
Get an error function that uses the nLTT statistic
}
\examples{

error_fun <- get_nltt_error_fun()

phylogeny <- ape::read.tree(text = "((A:1.5, B:1.5):1.5, C:3.0);")

tree_1 <- ape::read.tree(text = "((A:1.0, B:1.0):2.0, C:3.0);")
tree_2 <- ape::read.tree(text = "((A:2.0, B:2.0):1.0, C:3.0);")
trees <- c(tree_1, tree_2)

lowest_error <- error_fun(phylogeny, c(phylogeny))
}
\author{
Richèl J.C. Bilderbeek
}
