% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/scrape.R
\name{export}
\alias{export}
\title{Export (append) a data.frame to a remote table in a database.}
\usage{
export(connect, value, name, template, ...)
}
\arguments{
  \item{connect}{database connection.}

  \item{value}{local data frame.}

  \item{name}{name of the remote table.}

  \item{template}{a named character vector. The names of
  the vector should contain the names of \code{value}. The
  values of this vector should contain the relevant field
  types.}

  \item{...}{arguments passed onto
  \code{DBI::dbWriteTable}}
}
\description{
This function is convenient if you plan on repeatedly
appending to a table in a database. All that is required is
a database connection and a data.frame you want to export
to that database. If you want to initiate a table with more
columns use the \code{template} argument. Note that if the
table already exists, the \code{template} argument will be
ignored.
}
\examples{
\dontrun{
library(dplyr)
my_db <- src_sqlite("DB.sqlite3")
data(pitches, package="pitchRx")
# Creates the 'pitches' table in the database
export(connect=my_db$con, value=pitches, name="pitches")
# Appends to the 'pitches' tables, but with the first column missing
export(connect=my_db$con, value=pitches[,-1], name="pitches")
tail(data.frame(collect(tbl(my_db, "pitches")))) #verify it appends correctly
# This data frame has a column that doesn't exist in the pitches table --
# so a new table is created.
export(connect=my_db$con, value=cbind(pitches, test="works"), name="pitches")
}
}

