% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_height.R
\name{sprinkle_height}
\alias{sprinkle_height}
\alias{sprinkle_height.default}
\alias{sprinkle_height.dust_list}
\title{Adjust Table Cell Height}
\usage{
sprinkle_height(x, rows = NULL, cols = NULL, height = NULL,
  height_units = NULL, part = c("body", "head", "foot", "interfoot"),
  fixed = FALSE, recycle = c("none", "rows", "cols", "columns"), ...)

\method{sprinkle_height}{default}(x, rows = NULL, cols = NULL,
  height = NULL, height_units = NULL, part = c("body", "head", "foot",
  "interfoot"), fixed = FALSE, recycle = c("none", "rows", "cols",
  "columns"), ...)

\method{sprinkle_height}{dust_list}(x, rows = NULL, cols = NULL,
  height = NULL, height_units = NULL, part = c("body", "head", "foot",
  "interfoot"), fixed = FALSE, recycle = c("none", "rows", "cols",
  "columns"), ...)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{rows}{Either a numeric vector of rows in the tabular object to be 
modified or an object of class \code{call}.  When a \code{call}, 
generated by \code{quote(expression)}, the expression resolves to 
a logical vector the same length as the number of rows in the table.
Sprinkles are applied to where the expression resolves to \code{TRUE}.}

\item{cols}{Either a numeric vector of columns in the tabular object to
be modified, or a character vector of column names. A mixture of 
character and numeric indices is permissible.}

\item{height}{\code{numeric(1)}. Gives the height of the cell.}

\item{height_units}{\code{character(1)}. Gives the units for \code{height}.
One of \code{c("pt", "px", "cm", "in", "\%")}}

\item{part}{A character string denoting which part of the table to modify.}

\item{fixed}{\code{logical(1)} indicating if the values in \code{rows} 
and \code{cols} should be read as fixed coordinate pairs.  By default, 
sprinkles are applied at the intersection of \code{rows} and \code{cols}, 
meaning that the arguments do not have to share the same length.  
When \code{fixed = TRUE}, they must share the same length.}

\item{recycle}{A \code{character} one that determines how sprinkles are 
managed when the sprinkle input doesn't match the length of the region
to be sprinkled.  By default, recycling is turned off.  Recycling 
may be performed across rows first (left to right, top to bottom), 
or down columns first (top to bottom, left to right).}

\item{...}{Additional arguments to pass to other methods. Currently ignored.}
}
\description{
Customize the height of a cell in a table. This may be done
  to improve the appearance of cells with long text.
}
\details{
This sprinkle is only recognized by HTML and LaTeX.  All of the 
  \code{height_units} values are recognized by HTML.  For LaTeX, \code{"px"}
  is converted to \code{"pt"}.
}
\section{Functional Requirements}{

\enumerate{
 \item Correctly reassigns the appropriate elements of \code{height} 
   and \code{height_units} columns in the table part.
 \item Casts an error if \code{x} is not a \code{dust} object.
 \item Casts an error if \code{height} is not a \code{numeric(1)}
 \item Casts an error if \code{height_units} is not a \code{character(1)}
 \item Casts an error if \code{part} is not one of \code{"body"}, 
   \code{"head"}, \code{"foot"}, or \code{"interfoot"}
 \item Casts an error if \code{fixed} is not a \code{logical(1)}
 \item Casts an error if \code{recycle} is not one of \code{"none"},
   \code{"rows"}, or \code{"cols"}
}

The functional behavior of the \code{fixed} and \code{recycle} arguments 
is not tested for this function. It is tested and validated in the
tests for \code{\link{index_to_sprinkle}}.
}
\seealso{
\code{\link{sprinkle}}, 
  \code{\link{index_to_sprinkle}}
}

