% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archive.R
\name{cran_archive_list}
\alias{cran_archive_list}
\alias{cran_archive_update}
\alias{cran_archive_cleanup}
\alias{cran_archive_summary}
\title{Data about older versions of CRAN packages}
\usage{
cran_archive_list(
  cran_mirror = default_cran_mirror(),
  update_after = as.difftime(7, units = "days"),
  packages = NULL
)

cran_archive_update(cran_mirror = default_cran_mirror())

cran_archive_cleanup(cran_mirror = default_cran_mirror(), force = FALSE)

cran_archive_summary(cran_mirror = default_cran_mirror())
}
\arguments{
\item{cran_mirror}{CRAN mirror to use, see \code{\link[=default_cran_mirror]{default_cran_mirror()}}.}

\item{update_after}{\code{difftime} object. Automatically update the cache if
it gets older than this. Set it to \code{Inf} to avoid updates. Defaults
to seven days.}

\item{packages}{Character vector. Only report these packages.}

\item{force}{Force cleanup in non-interactive mode.}
}
\value{
\code{cran_archive_list()} returns a tibble with columns:
\itemize{
\item \code{package}: package name,
\item \code{version}: package version. This is a character vector, and not
a \code{\link[=package_version]{package_version()}} object. Some older package versions are not
supported by \code{\link[=package_version]{package_version()}}.
\item \code{raw}: the raw row names from the CRAN metadata.
\item \code{mtime}: \code{mtime} column from the CRAN metadata. This is usually
pretty close to the release date and time of the package.
\item \code{url}: package download URL.
\item \code{mirror}: CRAN mirror that was used to get this data.
The output is ordered according to package names (case insensitive) and
release dates.
}

\code{cran_archive_update()} returns all archive data in a tibble,
in the same format as \code{cran_archive_list()}, invisibly.

\code{cran_archive_cleanup()} returns nothing.

\code{cran_archive_summary()} returns a named list with elements:
\itemize{
\item \code{cachepath}: Path to the directory that contains all archive cache.
\item \code{current_rds}: Path to the RDS file that contains the data for
the specified \code{cran_mirror}.
\item \code{lockfile}: Path to the lock file for \code{current_rds}.
\item \code{timestamp}: Path to the time stamp for \code{current_rds}. \code{NA} if the
cache is empty.
\item \code{size}: Size of \code{current_rds}. Zero if the cache is empty.
}
}
\description{
CRAN mirrors store older versions of packages in \verb{/src/contrib/Archive},
and they also store some metadata about them in
\verb{/src/contrib/Meta/archive.rds}. pkgcache can download and cache this
metadata.
}
\details{
\code{cran_archive_list()} lists all versions of all (or some) packages.
It updates the cached data first, if it is older than the specified
limit.

\code{cran_archive_update()} updates the archive cache.

\code{cran_archive_cleanup()} cleans up the archive cache for
\code{cran_mirror}.

\code{cran_archive_summary()} prints a summary about the archive
cache.
}
\examples{
\dontshow{if (pkgcache:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cran_archive_list(packages = "readr")
\dontshow{\}) # examplesIf}
}
\seealso{
The \code{cran_archive_cache} class for more flexibility.
}
