% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/installed.R
\name{parse_packages}
\alias{parse_packages}
\title{Parse a repository metadata \verb{PACAKGES*} file}
\usage{
parse_packages(path)
}
\arguments{
\item{path}{Path to \code{PACKAGES}. The file can be \code{gzip} compressed, with
extension \code{.gz}; \code{bzip2} compressed, with extension \code{.bz2} or \code{bzip2};
or \code{xz} compressed with extension \code{xz}. It may also be a \code{PACKAGES.rds}
file, which will be read using \code{\link[base:readRDS]{base::readRDS()}}. Otherwise the file at
\code{path} is assumed to be uncompressed.}
}
\value{
A tibble, with all columns from the file at \code{path}.
}
\description{
Parse a repository metadata \verb{PACAKGES*} file
}
\details{
Non-existent, unreadable or corrupt \code{PACKAGES} files with trigger an
error.

\verb{PACKAGES*} files do not usually declare an encoding, but nevertheless
\code{parse_packages()} works correctly if they do.
}
\section{Note}{
\code{parse_packages()} cannot currently read files that have very many
different fields (many columns in the result tibble). The current
limit is 1000. Typical \code{PACKAGES} files contain less than 20 field
types.
}

