% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-cache.R
\name{package_cache}
\alias{package_cache}
\title{A simple package cache}
\description{
This is an R6 class that implements a concurrency safe package cache.
}
\details{
By default these fields are included for every package:
\itemize{
\item \code{fullpath} Full package path.
\item \code{path} Package path, within the repository.
\item \code{package} Package name.
\item \code{url} URL it was downloaded from.
\item \code{etag} ETag for the last download, from the given URL.
\item \code{sha256} SHA256 hash of the file.
}

Additional fields can be added as needed.

For a simple API to a session-wide instance of this class, see
\code{\link[=pkg_cache_summary]{pkg_cache_summary()}} and the other functions listed there.
}
\section{Usage}{
\preformatted{pc <- package_cache$new(path = NULL)

pc$list()
pc$find(..., .list = NULL)
pc$copy_to(..., .list = NULL)
pc$add(file, path, sha256 = shasum256(file), ..., .list = NULL)
pc$add_url(url, path, ..., .list = NULL, on_progress = NULL,
  http_headers = NULL)
pc$async_add_url(url, path, ..., .list = NULL, on_progress = NULL,
  http_headers = NULL)
pc$copy_or_add(target, urls, path, sha256 = NULL, ..., .list = NULL,
               on_progress = NULL, http_headers = NULL)
pc$async_copy_or_add(target, urls, path, ..., sha256 = NULL, ...,
               .list = NULL, on_progress = NULL, http_headers = NULL)
pc$update_or_add(target, urls, path, ..., .list = NULL,
               on_progress = NULL, http_headers = NULL)
pc$async_update_or_add(target, urls, path, ..., .list = NULL,
               on_progress = NULL, http_headers = NULL)
pc$delete(..., .list = NULL)
}
}

\section{Arguments}{

\itemize{
\item \code{path}: For \code{package_cache$new()} the location of the cache. For other
functions the location of the file inside the cache.
\item \code{...}: Extra attributes to search for. They have to be named.
\item \code{.list}: Extra attributes to search for, they have to in a named list.
\item \code{file}:  Path to the file to add.
\item \code{url}: URL attribute. This is used to update the file, if requested.
\item \code{sha256}: SHA256 hash of the file.
\item \code{on_progress}: Callback to create progress bar. Passed to internal
function \code{http_get()}.
\item \code{target}: Path to copy the (first) to hit to.
\item \code{urls}: Character vector or URLs to try to download the file from.
\item \code{http_headers}: HTTP headers to add to all HTTP queries.
}
}

\section{Details}{


\code{package_cache$new()} attaches to the cache at \code{path}. (By default
a platform dependent user level cache directory.) If the cache does
not exists, it creates it.

\code{pc$list()} lists all files in the cache, returns a data frame with all the
default columns, and potentially extra columns as well.

\code{pc$find()} list all files that match the specified criteria (\code{fullpath},
\code{path}, \code{package}, etc.). Custom columns can be searched for as well.

\code{pc$copy_to()} will copy the first matching file from the cache to
\code{target}. It returns the data frame of \emph{all} matching records, invisibly.
If no file matches, it returns an empty (zero-row) data frame.

\code{pc$add()} adds a file to the cache.

\code{pc$add_url()} downloads a file and adds it to the cache.

\code{pc$async_add_url()} is the same, but it is asynchronous.

\code{pc$copy_or_add()} works like \code{pc$copy_to()}, but if the file is not in
the cache, it tries to download it from one of the specified URLs first.

\code{pc$async_copy_or_add()} is the same, but asynchronous.

\code{pc$update_or_add()} is like \code{pc$copy_to_add()}, but if the file is in
the cache it tries to update it from the urls, using the stored ETag to
avoid unnecessary downloads.

\code{pc$async_update_or_add()} is the same, but it is asynchronous.

\code{pc$delete()} deletes the file(s) from the cache.
}

\examples{

## Although package_cache usually stores packages, it may store
## arbitrary files, that can be search by metadata
pc <- package_cache$new(path = tempfile())
pc$list()

cat("foo\n", file = f1 <- tempfile())
cat("bar\n", file = f2 <- tempfile())
pc$add(f1, "/f1")
pc$add(f2, "/f2")
pc$list()
pc$find(path = "/f1")
pc$copy_to(target = f3 <- tempfile(), path = "/f1")
readLines(f3)
}
