% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata-cache.R
\name{cranlike_metadata_cache}
\alias{cranlike_metadata_cache}
\title{Metadata cache for a CRAN-like repository}
\description{
This is an R6 class that implements the metadata cache of a CRAN-like
repository. For a higher level interface, see the \code{\link[=meta_cache_list]{meta_cache_list()}},
\code{\link[=meta_cache_deps]{meta_cache_deps()}}, \code{\link[=meta_cache_revdeps]{meta_cache_revdeps()}} and \code{\link[=meta_cache_update]{meta_cache_update()}}
functions.
}
\details{
The cache has several layers:
\itemize{
\item The data is stored inside the \code{cranlike_metadata_cache} object.
\item It is also stored as an RDS file, in the session temporary directory.
This ensures that the same data is used for all queries of a
\code{cranlike_metadata_cache} object.
\item It is stored in an RDS file in the user's cache directory.
\item The downloaded raw \verb{PACKAGES*} files are cached, together with HTTP
ETags, to minimize downloads.
}

It has a synchronous and an asynchronous API.
}
\section{Usage}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{cmc <- cranlike_metadata_cache$new(
  primary_path = NULL, replica_path = tempfile(),
  platforms = default_platforms(), r_version = getRversion(),
  bioc = TRUE, cran_mirror = default_cran_mirror(),
  repos = getOption("repos"),
  update_after = as.difftime(7, units = "days"))

cmc$list(packages = NULL)
cmc$async_list(packages = NULL)

cmc$deps(packages, dependencies = NA, recursive = TRUE)
cmc$async_deps(packages, dependencies = NA, recursive = TRUE)

cmc$revdeps(packages, dependencies = NA, recursive = TRUE)
cmc$async_revdeps(packages, dependencies = NA, recursive = TRUE)

cmc$update()
cmc$async_update()
cmc$check_update()
cmc$asnyc_check_update()

cmc$summary()

cmc$cleanup(force = FALSE)
}\if{html}{\out{</div>}}
}

\section{Arguments}{

\itemize{
\item \code{primary_path}: Path of the primary, user level cache. Defaults to
the user level cache directory of the machine.
\item \code{replica_path}: Path of the replica. Defaults to a temporary directory
within the session temporary directory.
\item \code{platforms}: see \code{\link[=default_platforms]{default_platforms()}} for possible values.
\item \code{r_version}: R version to create the cache for.
\item \code{bioc}: Whether to include BioConductor packages.
\item \code{cran_mirror}: CRAN mirror to use, this takes precedence over \code{repos}.
\item \code{repos}: Repositories to use.
\item \code{update_after}: \code{difftime} object. Automatically update the cache if
it gets older than this. Set it to \code{Inf} to avoid updates. Defaults
to seven days.
\item \code{packages}: Packages to query, character vector.
\item \code{dependencies}: Which kind of dependencies to include. Works the same
way as the \code{dependencies} argument of \code{\link[utils:install.packages]{utils::install.packages()}}.
\item \code{recursive}: Whether to include recursive dependencies.
\item \code{force}: Whether to force cleanup without asking the user.
}
}

\section{Details}{


\code{cranlike_metadata_cache$new()} creates a new cache object. Creation
does not trigger the population of the cache. It is only populated on
demand, when queries are executed against it. In your package, you may
want to create a cache instance in the \code{.onLoad()} function of the
package, and store it in the package namespace. As this is a cheap
operation, the package will still load fast, and then the package code
can refer to the common cache object.

\code{cmc$list()} lists all (or the specified) packages in the cache.
It returns a data frame, see the list of columns below.

\code{cmc$async_list()} is similar, but it is asynchronous, it returns a
\code{deferred} object.

\code{cmc$deps()} returns a data frame, with the (potentially recursive)
dependencies of \code{packages}.

\code{cmc$async_deps()} is the same, but it is asynchronous, it
returns a \code{deferred} object.

\code{cmc$revdeps()} returns a data frame, with the (potentially recursive)
reverse dependencies of \code{packages}.

\code{cmc$async_revdeps()} does the same, asynchronously, it returns an
\code{deferred} object.

\code{cmc$update()} updates the the metadata (as needed) in the cache,
and then returns a data frame with all packages, invisibly.

\code{cmc$async_update()} is similar, but it is asynchronous.

\code{cmc$check_update()} checks if the metadata is current, and if it is
not, it updates it.

\code{cmc$async_check_update()} is similar, but it is asynchronous.

\code{cmc$summary()} lists metadata about the cache, including its
location and size.

\code{cmc$cleanup()} deletes the cache files from the disk, and also from
memory.
}

\section{Columns}{

The metadata data frame contains all available versions (i.e. sources and
binaries) for all packages. It usually has the following columns,
some might be missing on some platforms.
\itemize{
\item \code{package}: Package name.
\item \code{title}: Package title.
\item \code{version}: Package version.
\item \code{depends}: \code{Depends} field from \code{DESCRIPTION}, or \code{NA_character_}.
\item \code{suggests}: \code{Suggests} field from \code{DESCRIPTION}, or \code{NA_character_}.
\item \code{built}:  \code{Built} field from \code{DESCIPTION}, if a binary package,
or \code{NA_character_}.
\item \code{imports}: \code{Imports} field from \code{DESCRIPTION}, or \code{NA_character_}.
\item \code{archs}: \code{Archs} entries from \code{PACKAGES} files. Might be missing.
\item \code{repodir}: The directory of the file, inside the repository.
\item \code{platform}: This is a character vector. See \code{\link[=default_platforms]{default_platforms()}} for
more about platform names. In practice each value of the \code{platform}
column is either
\itemize{
\item \code{"source"} for source packages,
\item a platform string, e.g. \code{x86_64-apple-darwin17.0} for macOS
packages compatible with macOS High Sierra or newer.
}
\item \code{needscompilation}: Whether the package needs compilation.
\item \code{type}: \code{bioc} or \code{cran}  currently.
\item \code{target}: The path of the package file inside the repository.
\item \code{mirror}: URL of the CRAN/BioC mirror.
\item \code{sources}: List column with URLs to one or more possible locations
of the package file. For source CRAN packages, it contains URLs to
the \code{Archive} directory as well, in case the package has been
archived since the metadata was cached.
\item \code{filesize}: Size of the file, if known, in bytes, or \code{NA_integer_}.
\item \code{sha256}: The SHA256 hash of the file, if known, or \code{NA_character_}.
\item \code{deps}: All package dependencies, in a data frame.
\item \code{license}: Package license, might be \code{NA} for binary packages.
\item \code{linkingto}: \code{LinkingTo} field from \code{DESCRIPTION}, or \code{NA_character_}.
\item \code{enhances}: \code{Enhances} field from \code{DESCRIPTION}, or \code{NA_character_}.
\item \code{os_type}: \code{unix} or \code{windows} for OS specific packages. Usually \code{NA}.
\item \code{priority}: "optional", "recommended" or \code{NA}. (Base packages are
normally not included in the list, so "base" should not appear here.)
\item \code{md5sum}: MD5 sum, if available, may be \code{NA}.
\item \code{sysreqs}: For CRAN packages, the \code{SystemRequirements} field, the
required system libraries or other software for the package. For
non-CRAN packages it is \code{NA}.
\item \code{published}: The time the package was published at, in GMT,
\code{POSIXct} class.
}

The data frame contains some extra columns as well, these are for internal
use only.
}

\examples{
\dontshow{if (pkgcache:::run_examples()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dir.create(cache_path <- tempfile())
cmc <- cranlike_metadata_cache$new(cache_path, bioc = FALSE)
cmc$list()
cmc$list("pkgconfig")
cmc$deps("pkgconfig")
cmc$revdeps("pkgconfig", recursive = FALSE)
\dontshow{\}) # examplesIf}
}
