% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/installed.R
\name{parse_packages}
\alias{parse_packages}
\title{Parse a repository metadata \verb{PACAKGES*} file}
\usage{
parse_packages(path, type = NULL)
}
\arguments{
\item{path}{Path to the \verb{PACKAGES*} file.}

\item{type}{Type of the file. By default it is determined automatically.
Types:
\itemize{
\item \code{uncompressed},
\item \code{gzip} compressed,
\item \code{bzip2} compressed,
\item \code{xz} compressed.
\item \code{rds}, an RDS file, which will be read using \code{\link[base:readRDS]{base::readRDS()}}.
}}
}
\value{
A data frame, with all columns from the file at \code{path}.
}
\description{
Parse a repository metadata \verb{PACAKGES*} file
}
\details{
Non-existent, unreadable or corrupt \code{PACKAGES} files with trigger an
error.

\verb{PACKAGES*} files do not usually declare an encoding, but nevertheless
\code{parse_packages()} works correctly if they do.
}
\section{Note}{
\code{parse_packages()} cannot currently read files that have very many
different fields (many columns in the result data frame). The current
limit is 1000. Typical \code{PACKAGES} files contain less than 20 field
types.
}

