% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppm.R
\name{ppm_r_versions}
\alias{ppm_r_versions}
\title{List all R versions supported by Posit Package Manager (PPM)}
\usage{
ppm_r_versions()
}
\value{
Data frame with columns:
\itemize{
\item \code{r_version}: minor R versions, i.e. version numbers containing the
first two components of R versions supported by this PPM instance.
}
}
\description{
List all R versions supported by Posit Package Manager (PPM)
}
\examples{
\dontshow{if (!pkgcache:::is_rcmd_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ppm_r_versions()
\dontshow{\}) # examplesIf}
}
\seealso{
The 'pkgcache and Posit Package Manager on Linux'
article at \url{https://r-lib.github.io/pkgcache/dev/}.

Other PPM functions: 
\code{\link{ppm_has_binaries}()},
\code{\link{ppm_platforms}()},
\code{\link{ppm_repo_url}()},
\code{\link{ppm_snapshots}()}
}
\concept{PPM functions}
