% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-remotes.R
\name{pkg_refs}
\alias{pkg_refs}
\title{Package references}
\description{
A package reference (ref) specifies a location from which an R package
can be obtained from. The full syntax of a reference is \code{type::ref}, but
\code{type} can be often omitted, the common ref types have shortcuts.
}
\details{
\subsection{Introduction}{

The currently supported reference types are:
\itemize{
\item \code{cran}: a CRAN package.
\item \code{bioc}: A Bioconductor package.
\item \code{standard}: a package from CRAN or Bioconductor.
\item \code{github}: A package from GitHub.
\item \code{local}: A local package file or directory.
\item \code{url}: An URL to a package archive.
\item \code{installed} An installed package.
\item \code{deps} The dependencies of a local package file or directory.
}

If a ref does not explicitly specify a type, then the following rules
are applied:
\itemize{
\item if the ref is a valid \code{standard} ref type (without the \verb{standard::}
prefix), then \code{standard} is used;
\item if the ref is a valid \code{github} ref type (without the \verb{github::}
prefix), then \code{github} is used;
\item if the ref is a GitHub URL, then \code{github} is used;
\item otherwise an error is thrown.
}
}

\subsection{Parameters}{

Package refs may have optional parameters, added after a question mark.
Different parameters are separated by an ampersand (\code{&}) character.
Parameters might be binary, or have a string value, assigned with an
equal sign (\code{=}). If no value is assigned, then we assume the \code{true}
value. For example these two package refs are the same:\preformatted{cran::testthat?source&nocache
cran::testthat?source=true&nocache=true
}

Currently supported parameters: * \code{source} is a binary parameter. If
specified, then a source R package is requested from a CRAN-like
repository. For package installations \code{source} always triggers a
re-install. In other words, \code{source} implies the \code{reinstall} parameter.
This parameter is supported for \verb{bioc::}, \verb{cran::} and \verb{standard::}
remote types, and it is ignore for others. * \code{reinstall} requests a
re-install for package installations. It is supported by the \verb{bioc::},
\verb{cran::}, \verb{github::}, \verb{local::}, \verb{standard::}, and \verb{url::} remote types.
* \code{nocache} will ignore the package cache. It will always download the
package file, and it will not add the downloaded (and built) file to the
package cache. It is supported by the \verb{bioc::}, \verb{cran::}, \verb{github::},
\verb{standard::} and \verb{url::} remote types.
\subsection{CRAN packages:}{

A package from CRAN. Full syntax:\preformatted{[cran::]<package>[@[>=]<version> | current | last]
}
\itemize{
\item \verb{<package>} is a valid package name.
\item \verb{<version>} is a version or a version requirement.
}

Examples:\preformatted{forecast
forecast@8.8
forecast@>=8.8
cran::forecast
forecast@last
forecast@current
}

Note: pkgdepends currently parses the version specification part
(everything after \code{@}), but does not use it.
}

\subsection{Bioconductor packages:}{

A package from Bioconductor. The syntax is the same as for CRAN
packages, except of the prefix of course:\preformatted{[bioc::]<package>[@[>=]<version> | current | last]
}
}

\subsection{Standard packages:}{

These are packages either from CRAN or Bioconductor, the full syntax is
the same as for CRAN packages, except for the prefix:\preformatted{[standard::]<package>[@[>=]<version> | current | last]
}
}

\subsection{GitHub packages:}{

Packages from a GitHub repository. Full syntax:\preformatted{[<package>=][github::]<username>/<repository>[/<subdir>][<detail>]
}
\itemize{
\item \verb{<package>} is the name of the package. If this is missing, then the
name of the repository is used.
\item \verb{<username>} is a GitHub username or organization name.
\item \verb{<repository>} is the name of the repository.
\item \verb{<subdir>} optional subdirectory, if the package is within a
subdirectory in the repository.
\item \verb{<detail>} specifies a certain version of the package, see below.
}

\verb{<detail>} may specify:
\itemize{
\item a git branch, tag or (prefix of) a commit hash: \verb{@<commitish>};
\item a pull request: \verb{#<pull-request>}; or
\item the latest release: \verb{@*release}.
}

If \verb{<detail>} is missing, then the latest commit of the \emph{default} branch
is used.

Examples:\preformatted{r-lib/crayon
github::r-lib/crayon
r-lib/crayon@84be6207
r-lib/crayon@branch
r-lib/crayon#41
r-lib/crayon@release
}

For convenience GitHub HTTP URLs can also be used to specify a package
from GitHub. Examples:\preformatted{https://github.com/r-lib/withr
# A branch:
https://github.com/r-lib/withr/tree/ghactions
# A tag:
https://github.com/r-lib/withr/tree/v2.1.1
# A commit:
https://github.com/r-lib/withr/commit/8fbcb548e316
# A pull request:
https://github.com/r-lib/withr/pull/76
# A release:
https://github.com/r-lib/withr/releases/tag/v2.1.0
}

A GitHub remote string can also be used instead of an URL, for example:
\code{git@github.com:r-lib/pkgdepends.git}
}

\subsection{Local packages:}{

A path that refers to a package file built with \verb{R CMD build}, or a
directory that contains a package. Full syntax:\preformatted{local::<path>
}

For brevity, you can omit the \verb{local::} prefix, if you specify an
absolute path, a path from the user’s home directory, starting with \code{~},
or a relative path starting with \verb{./} or \verb{.\\}.

A single dot (\code{"."}) is considered to be a local package in the current
working directory.

Examples:\preformatted{local::/foo/bar/package_1.0.0.tar.gz
local::/foo/bar/pkg
local::.
/absolute/path/package_1.0.0.tar.gz
~/path/from/home
./relative/path
.
}
}

\subsection{URLs:}{

You can use \verb{url::} to refer to URLs that hold R package archives
(i.e. properly built with \verb{R CMD build}), or compressed directories of
package trees (i.e. not built with \verb{R CMD build}). pkgdepends will
figure out if it needs to run \verb{R CMD build} on the package first.

This remote type supports \code{.tar.gz} and \code{.zip} files.

Note that URLs are not ideal remote types, because pkgdepends needs to
download the package file to resolve its dependencies. When this
happens, it puts the package file in the cache, so no further downloads
are needed when installing the package later.

Examples:\preformatted{url::https://cloud.r-project.org/src/contrib/Archive/cli/cli_1.0.0.tar.gz
url::https://github.com/tidyverse/stringr/archive/HEAD.zip
}
}

\subsection{Installed packages:}{

This is usually used internally, but can also be used directly. Full
syntax:\preformatted{installed::<path>/<package>
}
\itemize{
\item \verb{<path>} is the library the package is installed to.
\item \verb{<package>} is the package name.
}

Example:\preformatted{installed::~/R/3.6/crayon
}
}

\subsection{Package dependencies:}{

Usually used internally, it specifies the dependencies of a local
package. It can be used to download or install the dependencies of a
package, without downloading or installing the package itself. Full
syntax:\preformatted{deps::<path>
}

Examples:\preformatted{deps::/foo/bar/package_1.0.0.tar.gz
deps::/foo/bar/pkg
deps::.
}
}

}
}
