% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgdepends.R
\docType{package}
\name{pkgdepends-package}
\alias{pkgdepends}
\alias{pkgdepends-package}
\title{pkgdepends: Package Dependency Resolution and Downloads}
\description{
pkgdepends is a toolkit for package dependencies, downloads and
installations, to be used in other packages. If you are looking for a
package manager, see \href{https://github.com/r-lib/pak}{pak}.
}
\section{Features}{
\itemize{
\item Look up package dependencies recursively.
\item Visualize package dependencies.
\item Download packages and their dependencies.
\item Install downloaded packages.
\item Includes a dependency solver to find a consistent set of dependencies.
\item Supports CRAN and Bioconductor packages automatically.
\item Supports packages on GitHub.
\item Supports packages in git repositories.
\item Supports package bundles or files on the web.
\item Supports local package file and trees.
\item Supports the \code{Remotes} entry in the \code{DESCRIPTION} file.
\item Caches metadata and downloaded packages via
\href{https://github.com/r-lib/pkgcache}{pkgcache}
\item Performs all downloads and HTTP queries concurrently.
\item Builds and installs packages in parallel.
}
}

\section{Install}{
Once on CRAN, install the package with:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{install.packages("pkgdepends")
}\if{html}{\out{</div>}}
}

\section{Usage}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(pkgdepends)
}\if{html}{\out{</div>}}
\subsection{Package references}{

A package reference (ref) specifies a location from which an R package
can be obtained from. Examples:

\if{html}{\out{<div class="sourceCode">}}\preformatted{devtools
cran::devtools
bioc::Biobase
r-lib/pkgdepends
https://github.com/r-lib/pkgdepends
local::~/works/shiny
}\if{html}{\out{</div>}}

See \link[=pkg_refs]{“Package references”} for details.
}

\subsection{Package dependencies}{

Dependencies of the development version of the cli package:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pd <- new_pkg_deps("r-lib/pkgcache")
pd$solve()
pd$draw()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast"
style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000">
}}
\if{html}{\out{
<pre>
## <span style="color: #859900;">✔</span> Loading metadata database ... done                                    
## <span style="font-weight: bold;font-style: italic;color: #2AA198;">r-lib/pkgcache </span><span style="font-weight: bold;font-style: italic;color: #525252;">2.0.4.9001</span> <span style="color: #859900;">✨👷🏽🔧 </span>                                         
## ├─callr <span style="color: #525252;">3.7.3</span> <span style="color: #859900;">✨</span>                                                         
## │ ├─processx <span style="color: #525252;">3.8.0</span> <span style="color: #859900;">✨</span>                                                    
## │ │ ├─ps <span style="color: #525252;">1.7.3</span> <span style="color: #859900;">✨</span>                                                        
## │ │ └─R6 <span style="color: #525252;">2.5.1</span> <span style="color: #859900;">✨</span>                                                        
## │ └─R6                                                                  
## ├─cli <span style="color: #525252;">3.6.0</span> <span style="color: #859900;">✨</span>                                                           
## ├─curl <span style="color: #525252;">5.0.0</span> <span style="color: #859900;">✨</span>                                                          
## ├─filelock <span style="color: #525252;">1.0.2</span> <span style="color: #859900;">✨</span>                                                      
## ├─jsonlite <span style="color: #525252;">1.8.4</span> <span style="color: #859900;">✨</span>                                                      
## ├─prettyunits <span style="color: #525252;">1.1.1</span> <span style="color: #859900;">✨</span>                                                   
## ├─processx                                                              
## ├─R6                                                                    
## └─rappdirs <span style="color: #525252;">0.3.3</span> <span style="color: #859900;">✨</span>                                                      
##                                                                         
## Key:  <span style="color: #859900;">✨</span> new | <span style="color: #859900;">👷🏽 </span>build | 🔧<span style="color: #859900;"> </span>compile                                      
</pre>
}}
\if{html}{\out{
</div>
}}


See the \code{\link{pkg_deps}} class for details.
}

\subsection{Package downloads}{

Downloading all dependencies of a package:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pdl <- new_pkg_download_proposal("r-lib/cli")
pdl$resolve()
pdl$download()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast"
style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000">
}}
\if{html}{\out{
<pre>
## <span style="color: #2AA198;">ℹ</span> No downloads are needed, 1 pkg is cached                              
##                                                                         
</pre>
}}
\if{html}{\out{
</div>
}}


See the \code{\link{pkg_download_proposal}} class for
details.
}

\subsection{Package installation}{

Installing or updating a set of package:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{lib <- tempfile()
dir.create(lib)
pdi <- new_pkg_installation_proposal(
  "r-lib/cli",
  config = list(library = lib)
)
pdi$solve()
pdi$download()
pdi$install()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast"
style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000">
}}
\if{html}{\out{
<pre>
## <span style="color: #2AA198;">ℹ</span> No downloads are needed, 1 pkg is cached                              
## <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">cli</span> 3.6.0.9000 (github::r-lib/cli@8d8a211) <span style="color: #a3a3a3;">(36ms)</span>           
## <span style="color: #859900;">✔</span> Summary:  ✨ 1 new  in 36ms                                            
</pre>
}}
\if{html}{\out{
</div>
}}

}

\subsection{Dependency resolution}{

\code{\link{pkg_deps}},
\code{\link{pkg_download_proposal}} and
\code{\link{pkg_installation_proposal}} all resolve
their dependencies recursively, to obtain information about all packages
needed for the specified \link[=pkg_refs]{package references}. See
\link[=pkg_resolution]{“Dependency resolution”} for details.
}

\subsection{The dependency solver}{

The dependency solver takes the resolution information, and works out
the exact versions of each package that must be installed, such that
version and other requirements are satisfied. See \link[=pkg_solution]{“The dependency solver”} for details.
}

\subsection{Installation plans}{

\code{\link{pkg_installation_proposal}} can create
installation plans, and then also install them. It is also possible to
import installation plans that were created by other tools. See
\link[=install_plans]{“Installation plans”} for details.
}

\subsection{Configuration}{

The details of \code{\link{pkg_deps}},
\code{\link{pkg_download_proposal}} and
\code{\link{pkg_installation_proposal}} can be tuned
with a list of configuration options. See
\link[=pkgdepends-config]{“Configuration”} for details.
}
}

\section{Related}{
\itemize{
\item \href{https://github.com/r-lib/pak}{pak} – R package manager
\item \href{https://github.com/r-lib/pkgcache}{pkgcache} – Metadata and package
cache
\item \href{https://github.com/r-lib/devtools}{devtools} – Tools for R package
developers
}
\subsection{Code of Conduct}{

Please note that the pkgdepends project is released with a \href{https://r-lib.github.io/pkgdepends/dev/CODE_OF_CONDUCT.html}{Contributor Code of Conduct}.
By contributing to this project, you agree to abide by its terms.
}
}

\section{License}{
MIT (c) RStudio
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/r-lib/pkgdepends#readme}
  \item Report bugs at \url{https://github.com/r-lib/pkgdepends/issues}
}

}
\author{
\strong{Maintainer}: Gábor Csárdi \email{csardi.gabor@gmail.com}

Other contributors:
\itemize{
  \item RStudio [copyright holder, funder]
}

}
