% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sysreqs.R
\name{sysreqs_install_plan}
\alias{sysreqs_install_plan}
\title{Create an installation plan for system requirements}
\usage{
sysreqs_install_plan(refs, upgrade = TRUE, config = list())
}
\arguments{
\item{refs}{Packages to install.}

\item{upgrade}{If \code{TRUE}, pkgdepends will choose the latest available
versions of packages, instead of preferring binary packages over
source packages.}

\item{config}{Configuration options. See
\link[=pkgdepends-config]{'Configuration'}. If it does not include
\code{library}, then a temporary library is used, which is equivalent to
not assuming any preinstalled packages. Pass \code{sysreqs_platform} here
if you want a different platform than the one R is running on.}
}
\value{
List with entries:
\itemize{
\item \code{os}: character string. Operating system.
\item \code{distribution}: character string. Linux distribution, \code{NA} if the
OS is not Linux.
\item \code{version}: character string. Distribution version, \code{NA} is the OS
is not Linux.
\item \code{pre_install}: character vector. Commands to run before the
installation of system packages.
\item \code{install_scripts}: character vector. Commands to run to install the
system packages.
\item \code{post_install}: character vector. Commands to run after the
installation of system packages.
\item \code{packages}: data frame. Information about the system packages that
are needed. It has columns:
\itemize{
\item \code{sysreq}: string, cross-platform name of the system requirement.
\item \code{packages}: list column of character vectors. The names of the R
packages that have this system requirement.
\item \code{pre_install}: list column of character vectors. Commands run
before the package installation for this system requirement.
\item \code{system_packages}: list column of character vectors. Names of
system packages to install.
\item \code{post_install}: list column of character vectors. Commands run
after the package installation for this system requirement.
}
}
}
\description{
This function uses \code{\link[=new_pkg_installation_proposal]{new_pkg_installation_proposal()}} and its methods
to create an installation plan for one or more packages, and then print
their system requirements.
}
\examples{
\dontshow{if (!pkgdepends:::is_rcmd_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sysreqs_install_plan(
  "tidyverse",
  config = list(sysreqs_platform = "ubuntu-22.04")
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=new_pkg_installation_proposal]{new_pkg_installation_proposal()}} to actually install
packages, and potentially system requirements.

Other system requirements functions: 
\code{\link{sysreqs_check_installed}()},
\code{\link{sysreqs_db_list}()},
\code{\link{sysreqs_db_match}()},
\code{\link{sysreqs_db_update}()},
\code{\link{sysreqs_is_supported}()},
\code{\link{sysreqs_list_system_packages}()},
\code{\link{sysreqs_platforms}()}
}
\concept{system requirements functions}
