% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-home.R
\name{build_home}
\alias{build_home}
\title{Build home page}
\usage{
build_home(pkg = ".", override = list(), preview = NA, quiet = TRUE)
}
\arguments{
\item{pkg}{Path to package.}

\item{override}{An optional named list used to temporarily override
values in \code{_pkgdown.yml}}

\item{preview}{If \code{TRUE}, or \code{is.na(preview) && interactive()}, will preview
freshly generated section in browser.}

\item{quiet}{Set to \code{FALSE} to display output of knitr and
pandoc. This is useful when debugging.}
}
\description{
First looks for \code{index.Rmd} or \code{README.Rmd}, then
\code{index.md} or \code{README.md}. If none are found, falls back to the
description field in \code{DESCRIPTION}.
}
\section{Images and figures}{

If you want to images in your \code{README.md}, they must be stored in
somewhere in the package so that they can be displayed on the CRAN
website. The best place to put them appears to be \code{man/figures}.
If you are generating figures with R Markdown, make sure you set up
\code{fig.path} as followed:

\preformatted{
```\{r, include = FALSE\}
knitr::opts_chunk$set(
  fig.path = "man/figures/"
)
```
}
}

\section{YAML config}{

To tweak the home page, you need a section called \code{home}.

The sidebar links are automatically generated by inspecting the
\code{URL} and \code{BugReports} fields of the \code{DESCRIPTION}.
You can add additional links with a subsection called \code{links},
which should contain a list of \code{text} + \code{href} elements:\preformatted{home:
  links:
  - text: Link text
    href: http://website.com
}

The "developers" list is populated by the maintainer ("cre"), authors
("aut"), and funder ("fnd").

You can remove the first heading with\preformatted{home:
  strip_header: true
}
}

\section{Badges}{

Status badges are displayed in the sidebar under the section "Dev status".
This section is automatically populated if the first paragraph of the
homepage consists solely of status badges as linked images.
}

