% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.r
\name{render_page}
\alias{render_page}
\alias{data_template}
\title{Render page with template}
\usage{
render_page(pkg = ".", name, data, path = "", depth = NULL,
  quiet = FALSE)

data_template(pkg = ".", depth = 0L)
}
\arguments{
\item{pkg}{Path to package to document.}

\item{name}{Name of the template (e.g. "home", "vignette", "news")}

\item{data}{Data for the template.

This is automatically supplemented with three lists:
\itemize{
\item \code{site}: \code{title} and path to \code{root}.
\item \code{yaml}: the \code{template} key from \code{_pkgdown.yml}.
\item \code{package}: package metadata including \code{name} and\code{version}.
}

See the full contents by running \code{\link[=data_template]{data_template()}}.}

\item{path}{Location to create file; relative to destination directory.
If \code{""} (the default), prints to standard out.}

\item{depth}{Depth of path relative to base directory.}

\item{quiet}{If \code{quiet}, will suppress output messages}
}
\description{
Each page is composed of four templates: "head", "header", "content", and
"footer". Each of these templates is rendered using the \code{data}, and
then assembled into an overall page using the "layout" template.
}
