% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotd3.R
\name{plotd3}
\alias{plotd3}
\title{plotd3}
\usage{
plotd3(x, height = 500, width = 1000)
}
\arguments{
\item{x}{plot object generated by \code{\link{neighborhood_graph}} or
\code{\link{make_neighborhood_graph}} of type igraph}

\item{height}{parameter to change the height of the d3 plot. Default is 500}

\item{width}{parameter to change the width of the d3 plot. Default is 1000}
}
\description{
D3 network of a pkggraph object
}
\examples{
\dontrun{
  pkggraph::init(local = TRUE)
  plot_obj <- pkggraph::neighborhood_graph("hash")
  pkggraph::plotd3(plot_obj)

  plot_obj <- pkggraph::neighborhood_graph(c("hash","tidytext"))
  pkggraph::plotd3(plot_obj, height = 750, width = 1200)

  plot_obj <- pkggraph::neighborhood_graph(c("hash","Matrix"))
  pkggraph::plotd3(plot_obj)
}
}
\author{
Nikhil Singh
}
