#' An example A-Ci curve
#' @description CO2 response of leaf photosynthesis, as measured with a Licor6400.
#' @name acidata1
#' @docType data
#' @format
#' \describe{
#' \item{CO2S}{CO2 concentration in cuvette (ppm)}
#' \item{Ci}{Intercellular CO2 concentration (ppm)}
#' \item{Tleaf}{Leaf temperature (deg C)}
#' \item{Photo}{Net photosynthesis rate (mu mol m-2 s-1)}
#' }
NULL

#' An example dataset with multiple A-Ci curves
#' @description CO2 response of leaf photosynthesis, as measured with a Licor6400, for multiple leaves.
#' @name manyacidat
#' @docType data
#' @format
#' \describe{
#' \item{Curve}{An identifier for the A-Ci curve (28 curves in total, 13-14 points per curve)}
#' \item{Ci}{Intercellular CO2 concentration (ppm)}
#' \item{Photo}{Net photosynthesis rate (mu mol m-2 s-1)}
#' \item{Tleaf}{Leaf temperature (deg C)}
#' \item{PPFD}{Photosynthetic photon flux density (mu mol m-2 s-1)}
#' }
NULL
