% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_grid.R
\name{z_grid}
\alias{z_grid}
\title{Plots multiple platemaps with heatmap of scaled values}
\usage{
z_grid(data, well, plate_id, ncols = 2, plate = 96, each = FALSE,
  scale_each = FALSE, ...)
}
\arguments{
\item{data}{Numerical values to be plotted}

\item{well}{Vector of well identifiers e.g "A01"}

\item{plate_id}{Vector of plate identifiers e.g "Plate_1"}

\item{ncols}{Number of columns to display multiple heatmaps}

\item{plate}{Number of wells in complete plate (96, 384 or 1569)}

\item{each}{boolean, allowed for backwards compatibility, \code{scale_each}
is now the preferred argument name}

\item{scale_each}{boolean, if true scales each plate individually, if false
will scale the pooled values of \code{data}}

\item{...}{additional parameters to plot wrappers}
}
\value{
ggplot plot
}
\description{
Converts numerical values. well labels, and plate labels into multiple
plate heatmaps
}
\examples{
df01 <- data.frame(well = num_to_well(1:96),
  vals = rnorm(96),
  plate = 1)

df02 <- data.frame(well = num_to_well(1:96),
  vals = rnorm(96),
  plate = 2)

df <- rbind(df01, df02)

z_grid(data = df$vals,
       well = df$well,
       plate_id = df$plate,
       plate = 96)
}
