% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pl_cache.R
\name{pl_cache}
\alias{pl_cache}
\alias{pl_cache_clear}
\title{Cache data locally for later usage.}
\usage{
pl_cache(force = FALSE, ...)

pl_cache_clear(which = NULL, prompt = TRUE)
}
\arguments{
\item{force}{(logical) Force update of the cache. Default: \code{FALSE}}

\item{...}{Curl options, see \code{\link[curl]{curl_options}}}

\item{which}{(character) One of locations, names, or places.}

\item{prompt}{(logical) Prompt before clearing all files in cache?
No prompt used when DOIs passed in. Default: \code{TRUE}}
}
\description{
Cache data locally for later usage.
}
\details{
data are cached in \code{rappdirs::user_cache_dir("pleiades")}
}
\examples{
\dontrun{
pl_cache()
# pl_cache(force = TRUE)

# clear all files
# pl_cache_clear()

# clear a single file
# pl_cache_clear(which = "locations")
# pl_cache_clear(which = "places")
# pl_cache_clear(which = "names")
}
}
