\name{stepplfm}
\alias{stepplfm}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Probabilistic latent feature analysis of two-way two-mode frequency data}
\description{The function \code{\link{stepplfm}} subsequently applies the \code{\link{plfm}} function to fit disjunctive and/or conjunctive models with \emph{minF} up to \emph{maxF} latent features. 
             The results of the different models are stored in a list.}  
\usage{
	stepplfm(minF,maxF,data,object,attribute,
 	rating,freq1,freqtot,datatype="freq",
	maprule="disj",M=5,emcrit1=1e-2,emcrit2=1e-10,
        printrun=TRUE)
}
\arguments{
  \item{minF}{Minimum number of features to be fitted}
  \item{maxF}{Maximum number of features to be fitted}
  \item{data}{ A data frame that consists of three components: the variables 
               \code{object}, \code{attribute} and \code{rating}. Each row of the data frame describes the outcome of a binary rater judgement
               about the association between a certain object and a certain attribute.} 
  \item{object}{The name of the \code{object} component in the data frame \code{data}. The values of the vector \code{data$object} should be (non-missing) numeric or character values.}
  \item{attribute}{The name of the \code{attribute} component in the data frame \code{data}. The values of the vector \code{data$attribute} should be (non-missing) numeric or character values.}
  \item{rating}{The name of the \code{rating} component in the data frame \code{data}. The elements of the vector \code{data$rating} should be the numeric values 0 (no association) or 1 (association), 
                or should be specified as missing (NA).}
  \item{freq1}{\emph{J X K} matrix of observed association frequencies.}
  \item{freqtot}{A \emph{J X K} matrix with the total number of binary ratings in each cell \emph{(j,k)}. If the total number of ratings is the same for all cells of the matrix 
                 it is sufficient to enter a single numeric value rather than a matrix. For instance, if \emph{N} raters have judged \emph{J X K} associations, 
                 one may specify \code{freqtot}\emph{=N}.}
  \item{datatype}{The type of data used as input. When \code{datatype}="freq" one should specify frequency data \code{freq1} and \code{freqtot}, and when \code{datatype}="dataframe" one should 
                  specify the name of the data frame \code{data}, and its components, \code{object}, \code{attribute} and \code{rating}.}
  \item{maprule}{Fit disjunctive models (\code{maprule}="disj"), conjunctive models (\code{maprule}="conj"), or both disjunctive and conjunctive models (\code{maprule}="disj/conj").}
  \item{M}{The number of times a particular model is estimated using random starting points.}
  \item{emcrit1}{Convergence criterion which indicates when the estimation algorithm should switch from Expectation-Maximization (EM) steps to EM+Newton-Rhapson steps.}
  \item{emcrit2}{Convergence criterion which indicates final convergence to a local maximum.}
  \item{printrun}{\code{printrun}=TRUE prints the analysis type (disjunctive or conjunctive), the number of features (\code{F}) and the number of the run to the output screen, whereas 
                 \code{printrun}=FALSE suppresses the printing.}
}

\details{
	 When only disjunctive or conjunctive analyses are requested (\code{maprule}="disj" or \code{maprule}="conj") 
         with \code{minF} to \code{maxF} features, the results of subsequent \code{\link{plfm}} analyses are stored in a list with \code{maxF-minF+1} components. 
         When both disjunctive and conjunctive analyses are  requested (\code{maprule}="disj/conj"), the results of the disjunctive and conjunctive analysis 
         are each stored in a list (named "disj" and "conj", respectively)  with \code{maxF-minF+1} components. 
         The final object generated by \code{\link{stepplfm}} combines the lists "disj" and "conj" in a list with two components.
}

\author{
Michel Meulders
}
%%\note{
%%  ~~further notes~~
%%}
\examples{


\dontrun{
## example 1:Perceptual analysis of associations between car models and car attributes

##load car data
data(car)


## compute 5 runs of disjunctive and conjunctive models with 1 up to 4 features
car.lst<-stepplfm(minF=1,maxF=4,maprule="disj/conj",freq1=car$freq1,
                  freqtot=car$freqtot,M=5,emcrit1=1e-6)

## print output of the conjunctive model with 4 features
car.lst$conj[[4]]

## print output of the stepplfm analysis on the car data
car.lst

##summarize and print output of stepplfm analysis on car data
sumcar<-summary(car.lst)
sumcar

## visualize fit of models with different mapping rules and a different number of features
par(pty="s")
par(mfrow=c(2,2))
plot(car.lst,which="BIC")
plot(car.lst,which="AIC")
plot(car.lst,which="VAF")
}


## example 2: analysis on determinants of anger-related behavior

## load anger data
data(anger)

## compute 1 run of disjunctive models with 1 up to 3 features
anger.lst<-stepplfm(minF=1,maxF=3,maprule="disj",freq1=anger$freq1,freqtot=anger$freqtot,M=1)

## print output of disjunctive model with 2 features

anger.lst[[2]]

## print output of stepplfm analysis on anger data
anger.lst

## summarize and print output of stepplfm analysis on anger data
sumanger<-summary(anger.lst)
sumanger

## visualize fit of models with different mapping rules and a different number of features

par(pty="s")
par(mfrow=c(2,2))
plot(anger.lst,which="BIC")
plot(anger.lst,which="AIC")
plot(anger.lst,which="VAF")

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
