% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_segmentation.R
\name{otsu}
\alias{otsu}
\title{Calculate Otsu's threshold}
\usage{
otsu(values)
}
\arguments{
\item{values}{A numeric vector with the pixel values.}
}
\value{
A double (threshold value).
}
\description{
Given a numeric vector with the pixel's intensities, returns the threshold
value based on Otsu's method, which minimizes the combined intra-class
variance
}
\examples{
img <- image_pliman("soybean_touch.jpg")
thresh <- otsu(img@.Data[,,3])
plot(img[,,3] < thresh)

}
\references{
Otsu, N. 1979. Threshold selection method from gray-level
histograms. IEEE Trans Syst Man Cybern SMC-9(1): 62–66. doi:
\doi{10.1109/tsmc.1979.4310076}
}
