% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_segmentation.R
\name{watershed2}
\alias{watershed2}
\title{Alternative watershed algorithm}
\usage{
watershed2(binary, dist_thresh = 0.75, plot = TRUE)
}
\arguments{
\item{binary}{A binary image}

\item{dist_thresh}{The distance threshold to create the}

\item{plot}{If \code{TRUE} (default) plots the labeled objects}
}
\value{
The labelled version of \code{binary}.
}
\description{
This is a basic watershed algorithm that can be used as a faster alternative
to \code{\link[EBImage:watershed]{EBImage::watershed()}}. I strongly suggest using this only with round
objects, since it doesn't consider both 'extension' and 'tolerance' arguments
of \code{\link[EBImage:watershed]{EBImage::watershed()}}.
}
\examples{
library(pliman)
img <- image_pliman("soybean_touch.jpg")
binary <- image_binary(img, "B")[[1]]
wts <- watershed2(binary)
range(wts)
}
