% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel.R
\name{readVCM}
\alias{readVCM}
\title{Read Variant Count Matrix (VCM) accompanying a GCTA GRM}
\usage{
readVCM(pfx, fid = NULL)
}
\arguments{
\item{pfx}{prefix of GRM file set}

\item{fid}{seperate after family ID (def=NULL, use IID only)}
}
\value{
matrix of variant count with sample ID in row and column names.
}
\description{
GRM (Genetic Relatedness Matrix) is the core formt of GCTA, which is a PLINK
binary  symmetric matrix  with  an  extra variant  count  matrix (VCM),  this
function reads the VCM.
}
\examples{
pfx <- file.path(system.file("extdata", package="plinkFile"), "m20")
(readVCM(pfx))

}
