% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individualQC.R
\name{evaluate_check_het_and_miss}
\alias{evaluate_check_het_and_miss}
\title{Evaluate results from PLINK missing genotype and heterozygosity rate check.}
\usage{
evaluate_check_het_and_miss(qcdir, name, imissTh = 0.03, hetTh = 3,
  interactive = FALSE)
}
\arguments{
\item{qcdir}{[character] path/to/directory/with/QC/results containing
name.imiss and name.het results as returned by plink --missing and plink
--het.}

\item{name}{[character] Prefix of PLINK files, i.e. name.bed, name.bim,
name.fam, name.het and name.imiss.}

\item{imissTh}{[double] Threshold for acceptable missing genotype rate in any
individual; has to be proportion between (0,1)}

\item{hetTh}{[double] Threshold for acceptable deviation from mean
heterozygosity in any individual. Expressed as multiples of standard
deviation of heterozygosity (het), i.e. individuals outside mean(het) +/-
hetTh*sd(het) will be returned as failing heterozygosity check; has to be
larger than 0.}

\item{interactive}{[logical] Should plots be shown interactively? When
choosing this option, make sure you have X-forwarding/graphical interface
available for interactive plotting. Alternatively, set interactive=FALSE and
save the returned plot object (p_het_imiss) via ggplot2::ggsave(p=p_het_imiss
, other_arguments) or pdf(outfile) print(p_het_imiss) dev.off().}
}
\value{
named [list] with i) fail_imiss dataframe containing FID (Family ID),
IID (Within-family ID), MISS_PHENO (Phenotype missing? (Y/N)), N_MISS (Number
of missing genotype call(s), not including obligatory missings), N_GENO (
Number of potentially valid call(s)), F_MISS (Missing call rate) of
individuals failing missing genotype check and ii) fail_het dataframe
containing FID (Family ID), IID (Within-family ID), O(HOM) (Observed number
of homozygotes), E(HOM) (Expected number of homozygotes), N(NM) (Number of
non-missing autosomal genotypes), F (Method-of-moments F coefficient
estimate) of individuals failing  outlying heterozygosity check and iii)
p_het_imiss, a ggplot2-object 'containing' a scatter plot with the samples'
missingness rates on x-axis and their heterozygosity rates on the y-axis,
which can be shown by print(p_het_imiss).
}
\description{
Evaluates and depicts results from plink --missing (missing genotype rates
per individual) and plink --het (heterozygosity rates per individual) via
\code{\link{run_check_heterozygosity}} and
\code{\link{run_check_missingness}} or externally conducted check.)
Non-systematic failures in genotyping and outlying heterozygosity (hz) rates
per individual are often proxies for DNA sample quality. Larger than expected
heterozygosity can indicate possible DNA contamination.
The mean heterozygosity in Plink is computed as hz_mean = (N-O)/N, where
N: number of non-missing genotypes and O:observed number of homozygous
genotypes for a given individual.
Mean heterozygosity can differ between populations and SNP genotyping panels.
Within a population and genotyping panel, a reduced heterozygosity rate can
indicate inbreeding - these individuals will then be returned by
check_relatedness as individuals that fail the relatedness filters.
\code{evaluate_check_het_and_miss} creates a scatter plot with the
individuals' missingness rates on x-axis and their heterozygosity rates on
the y-axis.
}
\details{
All, \code{\link{run_check_heterozygosity}},
\code{\link{run_check_missingness}} and
\code{\link{evaluate_check_het_and_miss}} can simply be invoked by
\code{\link{check_het_and_miss}}.

For details on the output data.frame fail_imiss and fail_het, check the
original description on the PLINK output format page:
\url{https://www.cog-genomics.org/plink/1.9/formats#imiss} and
\url{https://www.cog-genomics.org/plink/1.9/formats#het}
}
\examples{
package.dir <- find.package('plinkQC')
qcdir <- file.path(package.dir, 'extdata')
name <- "data"
fail_het_miss <- evaluate_check_het_and_miss(qcdir=qcdir, name=name,
interactive=FALSE)
}
