% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef-plmm.R
\name{coef.plmm}
\alias{coef.plmm}
\title{Coef method for "plmm" class}
\usage{
\method{coef}{plmm}(object, lambda, which = 1:length(object$lambda), drop = TRUE, ...)
}
\arguments{
\item{object}{An object of class "plmm."}

\item{lambda}{A numeric vector of lambda values.}

\item{which}{Vector of lambda indices for which coefficients to return.}

\item{drop}{Logical.}

\item{...}{Additional arguments.}
}
\value{
Either a numeric matrix (if model was fit on data stored in memory)
or a sparse matrix (if model was fit on data stored filebacked). Rownames are
feature names, columns are values of \code{lambda}.
}
\description{
Coef method for "plmm" class
}
\examples{
admix_design <- create_design(X = admix$X, outcome_col = admix$y)
fit <- plmm(design = admix_design)
coef(fit)[1:10, 41:45]
}
