% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef-cv-plmm.R
\name{coef.cv_plmm}
\alias{coef.cv_plmm}
\title{Coef method for "cv_plmm" class}
\usage{
\method{coef}{cv_plmm}(object, lambda, which = object$min, ...)
}
\arguments{
\item{object}{An object of class "cv_plmm."}

\item{lambda}{A numeric vector of lambda values.}

\item{which}{Vector of lambda indices for which coefficients to return. Defaults to lambda index with minimum CVE.}

\item{...}{Additional arguments (not used).}
}
\value{
Returns a named numeric vector. Values are the coefficients of the
model at the specified value of either \code{lambda} or \code{which}. Names are the
values of \code{lambda}.
}
\description{
Coef method for "cv_plmm" class
}
\examples{
admix_design <- create_design(X = admix$X, y = admix$y)
cv_fit <- cv_plmm(design = admix_design, return_fit = TRUE)
head(coef(cv_fit))

}
