% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/untransform.R
\name{untransform}
\alias{untransform}
\title{Untransform coefficient values back to the original scale}
\usage{
untransform(
  std_scale_beta,
  p,
  std_X_details,
  fbm_flag,
  plink_flag,
  use_names = TRUE
)
}
\arguments{
\item{std_scale_beta}{The estimated coefficients on the standardized scale}

\item{p}{The number of columns in the original design matrix}

\item{std_X_details}{A list with 3 elements describing the standardized design matrix BEFORE rotation; this should have elements 'scale', 'center', and 'ns'}

\item{fbm_flag}{Logical: is the corresponding design matrix filebacked?}

\item{plink_flag}{Logical: did these data come from PLINK files?
\strong{Note}: This flag matters because of how non-genomic features
are handled for PLINK files -- in data from PLINK files,
unpenalized columns are \emph{not} counted in the \code{p} argument. For delimited
files, \code{p} does include unpenalized columns. This difference has
implications for how the \code{untransform()} function determines the
appropriate dimensions for the estimated coefficient matrix it returns.}

\item{use_names}{Logical: should names be added? Defaults to TRUE. Set to FALSE inside of \code{cvf()} helper, as 'ns' will vary within CV folds.}
}
\value{
a matrix of estimated coeffcients, 'beta_vals', that is on the scale of the original data.
}
\description{
This function unwinds the initial standardization of the data to obtain
coefficient values on their original scale. It is called by plmm_format().
}
\keyword{internal}
