% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ternary.R
\name{effect}
\alias{effect}
\title{Draw a change in the probability distribution on an existing plot}
\usage{
effect(x, y, ..., length = 0.05)
}
\arguments{
\item{x, y}{\code{numeric} vectors of the first two probabilities. If
the probability distribution is unchanged, \code{x} and \code{y} should
have length one.}

\item{...}{\link{graphical parameters} such as \code{xpd} and the line
    characteristics \code{lend}, \code{ljoin} and \code{lmitre}:
    see \code{\link{par}}.}

\item{length}{length of the edges of the arrow head (in inches).}
}
\description{
Given the first two probabilities of a trinomial distribution
before and after a change, \code{effect} adds an arrow to an existing
ternary plot. If the probability distribution does not change, a
point (instead of an arrow) is added to the plot.
}
\section{Warning}{

Only when \code{effect} is passed to \code{\link[Ternary:AddToTernary]{AddToTernary}}
as the first argument, arrows and points are drawn consistently
with ternary coordinate system, otherwise \code{effect} draws both
arrows and points according to a Cartesian coorinate system
centered on \eqn{(0,0.5,0.5)}.
}

\examples{
TernaryPlot()

# Arrow
plot3logit:::effect(c(0.1, 0.2), c(0.3, 0.2))

# Point
plot3logit:::effect(0.3, 0.2)

# Compare the two coordinate systems
plot3logit:::effect(0.1, 0.2, pch = 19, col = 'red')
AddToTernary(plot3logit:::effect, list(c(0.1, 0.2, 0.7)), pch = 19, col = 'blue')

# The origin of Cartesian coordinate systems
plot3logit:::effect(0, 0, pch = 19, col = 'red')
AddToTernary(plot3logit:::effect, list(c(0, 0.5, 0.5)), pch = '+', col = 'white')

}
\keyword{internal}
