% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field_common.R
\name{gen_path}
\alias{gen_path}
\title{Generates a curve of the field}
\usage{
gen_path(p0, DeltaB, edge = 0.01, nmax = Inf, flink)
}
\arguments{
\item{p0}{starting point of the curve.}

\item{DeltaB}{either a matrix \eqn{\Delta^TB\in\textbf{R}^{1\times 2}}
or a vector of length 2, if the model is \emph{categorical}; otherwise
a matrix \eqn{\Delta^TB\in\textbf{R}^{1\times 1}} or a \code{numeric},
if the model is \emph{ordinal}.}

\item{edge}{width of the border of the ternary plot.}

\item{nmax}{maximum number of vectors.}

\item{flink}{named \code{list} of two functions: \code{linkfun}
and \code{linkinv}. The former is the link function, whereas
the latter is its inverse.}
}
\value{
Object of class \code{list}, where each component is a \code{list} of
two components: the ternary coordinates of the starting point
of the arrow, and the ternary coordinates of the tip of the
arrow.
}
\description{
Given the ternary coordinates of the starting point of the curve, it
generates the path of arrows until the edge of the ternary plot is
reached.
}
\seealso{
\code{\link[=linkfun]{linkfun()}}, \code{\link[=linkinv]{linkinv()}}.
}
\keyword{internal}
