% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract3logit.R
\name{extract3logit}
\alias{extract3logit}
\alias{extract3logit.default}
\alias{extract3logit.clm}
\alias{extract3logit.clm2}
\alias{extract3logit.mlogit}
\alias{extract3logit.model3logit}
\alias{extract3logit.multinom}
\alias{extract3logit.polr}
\alias{extract3logit.vgam}
\alias{extract3logit.vglm}
\title{Extract information from fitted models}
\usage{
extract3logit(x, ...)

\method{extract3logit}{default}(x, ...)

\method{extract3logit}{clm}(x, ...)

\method{extract3logit}{clm2}(x, ...)

\method{extract3logit}{mlogit}(x, ...)

\method{extract3logit}{model3logit}(x, ...)

\method{extract3logit}{multinom}(x, ...)

\method{extract3logit}{polr}(x, ...)

\method{extract3logit}{vgam}(x, ...)

\method{extract3logit}{vglm}(x, ...)
}
\arguments{
\item{x}{an object of any of the classes listed above. If instead, a list is
passed, it should be structured as described in section \strong{Details}.}

\item{...}{other arguments passed to other methods.}
}
\value{
An object of class \code{model3logit}.
}
\description{
\code{\link[=extract3logit]{extract3logit()}} extracts all information which is relevant for
computing the vector field(s) from the object passed to argument \code{x}. See
\strong{Details} for information on how new \code{S3} methods of generic
\code{\link[=extract3logit]{extract3logit()}} should be implemented.
}
\details{
When a specific method is not available for a fitted model, it is possible to
pass a list to argument \code{x}. In that case, the list should consists of the
following components (the order is irrelevant):
\itemize{
\item \code{levels}: vector of possible values of the dependent variable.  It should
be a character vector of lenght three, whose first element is interpreted
as the reference level, whereas the second and the third elements are
associated to the first and second columns of matrix \code{B} respectively.
\item \code{B}: matrix of regression coefficients. It should be a numeric matrix
(or any coercible object) with two columns if the model is cardinal, with
only one column if the model is ordinal. The number of rows should be equal
to the number of covariates and the names of covariates should be added as
row names. The intercepts should be included only in case of categorical
models, whereas column names, if provided, are ignored.
\item \code{alpha}: intercepts of ordinal models. It should be a numerical vector of
length two if the model is ordinal, otherwise this component should be
either set to \code{NULL} or missing.
\item \code{vcovB}: covariance matrix of regression coefficients. It  should be a
numeric matrix (or any coercible object) where the number of rows and
columns equals the number of elements of \code{B}. Rows and columns should
be ordered according to the labels of the dependent variable (slower
index), and then to the covariates (faster index).
}

If a new \code{S3} method for generic \code{\link[=extract3logit]{extract3logit()}} has to be implemented, the
following components may be set:
\itemize{
\item \code{readfrom}: character with information about the function that returned the
estimates in the form \verb{package::function} (for example \code{nnet::multinom},
\code{MASS::polr}, ...)
}

\strong{In any case}, once the list has been created, the new method should invoke
the default method \code{\link[=extract3logit.default]{extract3logit.default()}} and return its ouput. By so
doing, automatic checks and initialisations are run before the \code{model3logit}
object is returned.
}
\seealso{
\code{\link{plot3logit-package}}, \code{\link[=field3logit]{field3logit()}}.
}
