% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_image}
\alias{plot_image}
\title{Add images to plots.}
\usage{
plot_image(img, type = "image", col = NULL, show.axes = FALSE,
  xrange = c(0, 1), yrange = c(0, 1), fill.plotregion = FALSE,
  replace.colors = NULL, add = FALSE, interpolate = TRUE, ...)
}
\arguments{
\item{img}{Matrix or image object (list with 'image', a matrix, and 'col', 
a vector with color values), or a string indicating the filename of an 
image to read.}

\item{type}{String, 'image' (default), 'png', 'jpeg', 'gif'}

\item{col}{Vector with colors.}

\item{show.axes}{Logical: whether or not to plot the axes.}

\item{xrange}{Two-value vector providing the xleft and xright coordinate 
values of the picture. Default set to c(0,1).}

\item{yrange}{Two-value vector providing the ybottom and ytop coordinate 
values of the picture. Default set to c(0,1).}

\item{fill.plotregion}{Logical: whether or not to fill the complete plot 
region. Defaults to FALSE.}

\item{replace.colors}{Named list for replacing colors. The names are the 
colors (in hexadecimal values), or regular expressions matching colors. The 
values are the replacements.}

\item{add}{Logical: whether or not to add the plot to the current plot.}

\item{interpolate}{Logical: a logical vector (or scalar) indicating whether 
to apply linear interpolation to the image when drawing.}

\item{...}{Other arguments for plotting, see \code{\link[graphics]{par}}.}
}
\value{
Optionally returns
}
\description{
Add images to plots.
}
\examples{

# see Volcano example at help(image)
# create image object:
myimg <- list(image=volcano-min(volcano), col=terrain.colors(max(volcano)-min(volcano)))
# create emoty plot window:
emptyPlot(1,1, main="Volcano images")
# add image topleft corner:
plot_image(img=myimg, xrange=c(0,.25), yrange=c(.75,1), add=TRUE)
# add transparent image as overlay:
myimg$col <- alpha(myimg$col, f=.25)
plot_image(img=myimg, add=TRUE, fill.plotregion=TRUE, bty='n')
# add image:
myimg$col <- topo.colors(max(myimg$image))
plot_image(img=myimg, xrange=c(0.125,.375), yrange=c(.5,.875), add=TRUE)
# add some points and lines:
points(runif(10,0,1), runif(10,0,1), type='o')

}
\author{
Jacolien van Rij
}
\seealso{
Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{add_n_points}},
  \code{\link{alphaPalette}}, \code{\link{alpha}},
  \code{\link{check_normaldist}},
  \code{\link{color_contour}}, \code{\link{dotplot_error}},
  \code{\link{drawDevArrows}}, \code{\link{emptyPlot}},
  \code{\link{errorBars}}, \code{\link{fill_area}},
  \code{\link{getCoords}}, \code{\link{getFigCoords}},
  \code{\link{getProps}}, \code{\link{gradientLegend}},
  \code{\link{legend_margin}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_error}}, \code{\link{plotsurface}}
}

