% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight.R
\name{highlight}
\alias{highlight}
\title{Query graphical elements in multiple linked views}
\usage{
highlight(p, on = "plotly_click", off, persistent = getOption("persistent",
  FALSE), dynamic = FALSE, color = NULL, selectize = FALSE,
  defaultValues = NULL, opacityDim = getOption("opacityDim", 0.2),
  selected = attrs_selected(), ...)
}
\arguments{
\item{p}{a plotly visualization.}

\item{on}{turn on a selection on which event(s)? To disable on events 
altogether, use \code{NULL}. Currently the following are supported:
\itemize{
 \item \code{'plotly_click'}
 \item \code{'plotly_hover'}
 \item \code{'plotly_selected'}: triggered through rectangular 
 (layout.dragmode = 'select') or lasso (layout.dragmode = 'lasso') brush.
 Currently only works for scatter traces with mode 'markers'.
}}

\item{off}{turn off a selection on which event(s)? To disable off 
events altogether, use \code{NULL}. Currently the following are supported:
\itemize{
 \item \code{'plotly_doubleclick'}: triggered on a double mouse click while
 (layout.dragmode = 'zoom') or (layout.dragmode = 'pan')
 \item \code{'plotly_deselect'}: triggered on a double mouse click while 
 (layout.dragmode = 'select') or (layout.dragmode = 'lasso')
 \item \code{'plotly_relayout'}: triggered whenever axes are rescaled 
 (i.e., clicking the home button in the modebar) or whenever the height/width
 of the plot changes.
}}

\item{persistent}{should selections persist (i.e., accumulate)?}

\item{dynamic}{should a widget for changing selection colors be included?}

\item{color}{character string of color(s) to use for 
highlighting selections. See \code{\link{toRGB}()} for valid color
specifications. If \code{NULL} (the default), the color of selected marks
are not altered.}

\item{selectize}{provide a selectize.js widget for selecting keys? Note that 
the label used for this widget derives from the groupName of the SharedData object.}

\item{defaultValues}{a vector of values for setting a "default selection".
These values should match the key attribute.}

\item{opacityDim}{a number between 0 and 1 used to reduce the
opacity of non-selected traces (by multiplying with the existing opacity).}

\item{selected}{attributes of the selection, see \code{\link{attrs_selected}()}.}

\item{...}{currently not supported.}
}
\description{
This function sets a variety of options for brushing (i.e., highlighting)
multiple plots. These options are primarily designed for linking
multiple plotly graphs, and may not behave as expected when linking 
plotly to another htmlwidget package via crosstalk. In some cases,
other htmlwidgets will respect these options, such as persistent selection
in leaflet (see \code{demo("highlight-leaflet", package = "plotly")}).
}
\examples{

# These examples are designed to show you how to highlight/brush a *single*
# view. For examples of multiple linked views, see `demo(package = "plotly")` 


library(crosstalk)
d <- SharedData$new(txhousing, ~city)
p <- ggplot(d, aes(date, median, group = city)) + geom_line()
gg <- ggplotly(p, tooltip = "city") 
highlight(gg, persistent = TRUE, dynamic = TRUE)

# supply custom colors to the brush 
cols <- toRGB(RColorBrewer::brewer.pal(3, "Dark2"), 0.5)
highlight(
  gg, on = "plotly_hover", color = cols, persistent = TRUE, dynamic = TRUE
)

# Use attrs_selected() for complete control over the selection appearance
# note any relevant colors you specify here should override the color argument
s <- attrs_selected(
  showlegend = TRUE,
  mode = "lines+markers",
  marker = list(symbol = "x")
)

highlight(
 layout(gg, showlegend = TRUE),  
 selected = s, persistent = TRUE
)

}
\references{
\url{https://cpsievert.github.io/plotly_book/linking-views-without-shiny.html}
}
\seealso{
\code{\link{attrs_selected}()}
}
\author{
Carson Sievert
}
