% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mix_comps.R
\name{plot_mix_comps}
\alias{plot_mix_comps}
\title{Helper Function for Overlaying Mixture Components}
\usage{
plot_mix_comps(x, mu = NULL, sigma = NULL, lam = 1, beta0 = NULL,
 beta1=NULL, alpha=NULL, beta=NULL,
 normal=FALSE, logisreg=FALSE,
 gamma=FALSE, poisson=FALSE)
}
\arguments{
\item{x}{Input data}

\item{mu}{Component mean}

\item{sigma}{Component variance}

\item{lam}{Component mixture weight}

\item{beta0}{Coefficient values}

\item{beta1}{Coefficient values}

\item{alpha}{Initial shape parameters}

\item{beta}{Initial parameter values}

\item{normal}{Logical for normal distribution}

\item{logisreg}{Logical for logistic regression mixtures}

\item{gamma}{Logical for gamma distribution}

\item{poisson}{Logical for poisson regression mixtures}
}
\description{
Allows for plotting mixture components conditioned on a superimposed function meant for passage to ggplot's \code{stat_function()}
}
\details{
Allows for component curves to be superimposed over a mixture model plot
}
\examples{
\donttest{
if(require(mixtools)){
mixmdl <- mixtools::normalmixEM(faithful$waiting, k = 2)
}
x <- mixmdl$x
x <- data.frame(x)
ggplot2::ggplot(data.frame(x)) +
  ggplot2::geom_density(ggplot2::aes(x), color="black", fill="black") +
  ggplot2::stat_function(geom = "line", fun = plot_mix_comps,
                args = list(mixmdl$mu[1], mixmdl$sigma[1], lam = mixmdl$lambda[1]),
                colour = "red") +
  ggplot2::stat_function(geom = "line", fun = plot_mix_comps,
                args = list(mixmdl$mu[2], mixmdl$sigma[2], lam = mixmdl$lambda[2]),
               colour = "blue")
}

}
