% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{modCol}
\alias{contrastcol}
\alias{darkenCol}
\alias{modCol}
\alias{modhueCol}
\alias{saturateCol}
\title{Modify colors}
\usage{
modCol(col, darken = 0, saturate = 0, modhue = 0)

saturateCol(col, by = 0)

darkenCol(col, by = 0)

modhueCol(col, by = 0)

contrastcol(col, alpha = NULL)
}
\arguments{
\item{col}{a character vector of colors (palette) to modify -- a character vector}

\item{darken}{Use negative values to lighten, and positive to darken.}

\item{saturate}{Use negative values to desaturate, and positive to saturate}

\item{modhue}{Change the hue by a number of degrees (0-360)}

\item{by}{parameter for the saturateCol, darkenCol and modhueCol functions}

\item{alpha}{alpha value (from 0, transparent, to 255, fully opaque)}
}
\value{
a character vector containing the modified palette
}
\description{
Modify colors by shading, saturating and changing hue
}
\details{
This function use the HSL (hue, saturation, luminosity) scheme to modify
colors in a palette.

modCol is just a wrapper for the other three functions allowing to
modify three parameters in one go.

saturateCol, darkenCol and modhueCol modify the saturation, luminosity
and hue in the HSL color model.

contrastcol() returns black for each light color (with L > 0.5) and
white for each dark color (with L < 0.5).
}
\section{Functions}{
\itemize{
\item \code{saturateCol}: Change the saturation of a color or palette by a fraction of "by"

\item \code{darkenCol}: Modify the darkness of a color or palette (positve \code{by} - darken, negative \code{by} -- lighten)

\item \code{modhueCol}: Modify the hue of a character vector of colors by \code{by} degrees

\item \code{contrastcol}: Return white for dark colors, return black for light colors
}}
\examples{
plot.new()
## Loop over a few saturation / lightess values
par(usr=c(-0.5, 0.5, -0.5, 0.5))
v <- c(10, 9, 19, 9, 15, 5)
pal <- plotPals("zeileis")
for(sat in seq.int(-0.4, 0.4, length.out=5)) {
  for(lgh in seq.int(-0.4, 0.4, length.out=5)) {
    cols <- saturateCol(darkenCol(pal, by=sat), by=lgh)
    wgPlanets(x=sat, y=lgh, w=0.16, h=0.16, v=v, col=cols)
  }
}
axis(1)
axis(2)
title(xlab="Darkness (L) by=", ylab="Saturation (S) by=")

## Now loop over hues
a2xy <- function(a, r=1, full=FALSE) {
  t <- pi/2 - 2 * pi * a / 360
  list( x=r * cos(t), y=r * sin(t) )
}

plot.new()
par(usr=c(-1,1,-1,1))
hues <- seq(0, 360, by=30)
pos <- a2xy(hues, r=0.75)
for(i in 1:length(hues)) {
  cols <- modhueCol(pal, by=hues[i])
  wgPlanets(x=pos$x[i], y=pos$y[i], w=0.5, h=0.5, v=v, col=cols)
}

pos <- a2xy(hues[-1], r=0.4)
text(pos$x, pos$y, hues[-1])
}

