% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{aze}
\alias{aze}
\title{Microsatellites Dataset}
\format{
A data frame with 104 observations on the following 34 variables.
\describe{ \item{y}{the response: a binary vector (Astler-Coller
score).} \item{D2S138}{a binary vector that indicates whether this
microsatellite is altered or not.} \item{D18S61}{a binary vector
that indicates whether this microsatellite is altered or not.}
\item{D16S422}{a binary vector that indicates whether this
microsatellite is altered or not.} \item{D17S794}{a binary vector
that indicates whether this microsatellite is altered or not.}
\item{D6S264}{a binary vector that indicates whether this
microsatellite is altered or not.} \item{D14S65}{a binary vector
that indicates whether this microsatellite is altered or not.}
\item{D18S53}{a binary vector that indicates whether this
microsatellite is altered or not.} \item{D17S790}{a binary vector
that indicates whether this microsatellite is altered or not.}
\item{D1S225}{a binary vector that indicates whether this
microsatellite is altered or not.} \item{D3S1282}{a binary vector
that indicates whether this microsatellite is altered or not.}
\item{D9S179}{a binary vector that indicates whether this
microsatellite is altered or not.} \item{D5S430}{a binary vector
that indicates whether this microsatellite is altered or not.}
\item{D8S283}{a binary vector that indicates whether this
microsatellite is altered or not.} \item{D11S916}{a binary vector
that indicates whether this microsatellite is altered or not.}
\item{D2S159}{a binary vector that indicates whether this
microsatellite is altered or not.} \item{D16S408}{a binary vector
that indicates whether this microsatellite is altered or not.}
\item{D5S346}{a binary vector that indicates whether this
microsatellite is altered or not.} \item{D10S191}{a binary vector
that indicates whether this microsatellite is altered or not.}
\item{D13S173}{a binary vector that indicates whether this
microsatellite is altered or not.} \item{D6S275}{a binary vector
that indicates whether this microsatellite is altered or not.}
\item{D15S127}{a binary vector that indicates whether this
microsatellite is altered or not.} \item{D1S305}{a binary vector
that indicates whether this microsatellite is altered or not.}
\item{D4S394}{a binary vector that indicates whether this
microsatellite is altered or not.} \item{D20S107}{a binary vector
that indicates whether this microsatellite is altered or not.}
\item{D1S197}{a binary vector that indicates whether this
microsatellite is altered or not.} \item{D1S207}{a binary vector
that indicates whether this microsatellite is altered or not.}
\item{D10S192}{a binary vector that indicates whether this
microsatellite is altered or not.} \item{D3S1283}{a binary vector
that indicates whether this microsatellite is altered or not.}
\item{D4S414}{a binary vector that indicates whether this
microsatellite is altered or not.} \item{D8S264}{a binary vector
that indicates whether this microsatellite is altered or not.}
\item{D22S928}{a binary vector that indicates whether this
microsatellite is altered or not.} \item{TP53}{a binary vector that
indicates whether this microsatellite is altered or not.}
\item{D9S171}{a binary vector that indicates whether this
microsatellite is altered or not.} }
}
\source{
Weber \emph{et al.} (2007). Allelotyping analyzes of synchronous
primary and metastasis CIN colon cancers identified different subtypes.
\emph{Int J Cancer}, 120(3), pages 524-32.
}
\description{
This database was collected on patients carrying a colon adenocarcinoma. It
has 104 observations on 33 binary qualitative explanatory variables and one
response variable \code{y} representing the cancer stage according to the to
Astler-Coller classification (Astler and Coller, 1954). This dataset has
some missing data due to technical limits. A microsattelite is a non-coding
DNA sequence.
}
\examples{

data(aze)
str(aze)

}
\references{
Nicolas Meyer, Myriam Maumy-Bertrand et
Frédéric Bertrand (2010). Comparing the linear and the
logistic PLS regression with qualitative predictors: application to
allelotyping data. \emph{Journal de la Société Française de Statistique},
151(2), pages 1-18.
}
\keyword{datasets}
