% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lda_from_pls.R
\name{lda_from_pls_cv}
\alias{lda_from_pls_cv}
\title{Cross-validated LDA/QDA classification from PLS model}
\usage{
lda_from_pls_cv(model, X, y, ncomp, Y.add = NULL)
}
\arguments{
\item{model}{\code{pls} model fitted with the \code{pls} package}

\item{X}{predictors in the same format as in the \code{pls} model}

\item{y}{vector of grouping labels}

\item{ncomp}{maximum number of PLS components}

\item{Y.add}{additional responses}
}
\value{
matrix of classifications
}
\description{
For each number of components LDA/QDA models are created from the 
scores of the supplied PLS model and classifications are performed.
This use of cross-validation has limitations. Handle with care!
}
\examples{
data(mayonnaise, package = "pls")
mayonnaise <- within(mayonnaise, {dummy <- model.matrix(~y-1,data.frame(y=factor(oil.type)))})
pls <- plsr(dummy ~ NIR, ncomp = 15, data = mayonnaise, subset = train, 
            validation = "CV", segments = 40, segment.type = "consecutive")
with(mayonnaise, {
 classes <- lda_from_pls_cv(pls, NIR[train,], oil.type[train], 15)
 colSums(oil.type[train] == classes) # Number of correctly classified out of 120
})

}
\seealso{
\code{\link{VIP}} (SR/sMC/LW/RC), \code{\link{filterPLSR}}, \code{\link{shaving}}, 
\code{\link{stpls}}, \code{\link{truncation}},
\code{\link{bve_pls}}, \code{\link{ga_pls}}, \code{\link{ipw_pls}}, \code{\link{mcuve_pls}},
\code{\link{rep_pls}}, \code{\link{spa_pls}},
\code{\link{lda_from_pls}}, \code{\link{lda_from_pls_cv}}, \code{\link{setDA}}.
}

