% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covSel.R
\name{covSel}
\alias{covSel}
\title{Covariance Selection - CovSel}
\usage{
covSel(X, Y, nvar)
}
\arguments{
\item{X}{\code{matrix} of input variables}

\item{Y}{\code{matrix} of response variable(s)}

\item{nvar}{maximum number of variables}
}
\value{
\item{selected}{an integer vector of selected variables}
\item{scores}{a matrix of score vectors}
\item{loadings}{a matrix of loading vectors}
\item{Yloadings}{a matrix of Y loadings}
}
\description{
Sequential selection of variables based on squared covariance
with response and intermediate deflation (as in Partial Least Squares).
}
\examples{
data(gasoline, package = "pls")
sels <- with(gasoline, covSel(NIR, octane, 5))
matplot(t(gasoline$NIR), type = "l")
abline(v = sels$selected, col = 2)
}
\references{
J.M. Roger, B. Palagos, D. Bertrand, E. Fernandez-Ahumada. CovSel: Variable selection for highly multivariate and multi-response calibration: Application to IR spectroscopy. Chemom Intel Lab Syst. 2011;106(2):216-223.
P. Mishra, A brief note on a new faster covariate's selection (fCovSel) algorithm, Journal of Chemometrics 36(5) 2022.
}
