% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status-setter.R
\name{everyone}
\alias{everyone}
\alias{everyone_but}
\title{Select all authors or exclude some from a selection}
\usage{
everyone()

everyone_but(...)
}
\arguments{
\item{...}{One or more unquoted expressions separated by commas. Expressions
matching values in the column defined by the \code{by} parameter of \verb{set_*()}
methods are used to set a given status to authors. Matching of values is
case-insensitive.}
}
\description{
Selection helpers to use in conjonction with \verb{set_*()} methods:
\itemize{
\item \code{\link[=everyone]{everyone()}} select all authors.
\item \code{\link[=everyone_but]{everyone_but()}} select all but specific authors.
}
}
\examples{
aut <- Plume$new(encyclopedists)

aut$set_corresponding_authors(everyone())
aut$get_plume() |> dplyr::select(1:3, corresponding)

aut$set_corresponding_authors(
  everyone_but(jean),
  by = "given_name"
)
aut$get_plume() |> dplyr::select(1:3, corresponding)
}
